/* mbed library for the ST NUCLEO board L152RE 
 * to change the CPU clock to 32 MHz
 * A pll clock of 96 MHz is used to enable USB  
 *
 * Copyright (c) 2014 Peter Drescher - DC2PD
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "stm32l1xx.h"
#include "stm32l1xx_flash.h"
#include "stm32l1xx_rcc.h"
#include "ST_L152_32MHZ.h"

// only the constructor  
L152_init32::L152_init32(unsigned int external){
    Status = setup_clock_32MHZ(external);
    }

#define PLL_STARTUP_TIMEOUT 0x5000

ClockStatus L152_init32::setup_clock_32MHZ(int external)
{
    uint32_t PLLStartUpCounter = 0,PLLStatus = 0,error;

    RCC_DeInit();  // we have to reset the clock settings !
/* Enable 64-bit access */
    FLASH->ACR |= FLASH_ACR_ACC64;

    /* Enable Prefetch Buffer */
    FLASH->ACR |= FLASH_ACR_PRFTEN;

    /* Flash 1 wait state */
    FLASH->ACR |= FLASH_ACR_LATENCY;
    
    /* Power enable */
    RCC->APB1ENR |= RCC_APB1ENR_PWREN;
  
    /* Select the Voltage Range 1 (1.8 V) */
    PWR->CR = PWR_CR_VOS_0;
  
    /* Wait Until the Voltage Regulator is ready */
    while((PWR->CSR & PWR_CSR_VOSF) != RESET)
    {
    }
      
    /* HCLK = SYSCLK /1*/
    RCC->CFGR |= (uint32_t)RCC_CFGR_HPRE_DIV1;
    /* PCLK2 = HCLK /1*/
    RCC->CFGR |= (uint32_t)RCC_CFGR_PPRE2_DIV1;
    
    /* PCLK1 = HCLK /1*/
    RCC->CFGR |= (uint32_t)RCC_CFGR_PPRE1_DIV1;
  
    /*  PLL configuration */
    RCC->CFGR &= (uint32_t)((uint32_t)~(RCC_CFGR_PLLSRC | RCC_CFGR_PLLMUL |
                                        RCC_CFGR_PLLDIV));
                                        
    if(external == 0){                                                                        
        RCC->CFGR |= (uint32_t)(RCC_CFGR_PLLSRC_HSI | RCC_CFGR_PLLMUL6 | RCC_CFGR_PLLDIV3);
        }
    else{
        RCC_HSEConfig(RCC_HSE_ON);                // start external crystal osc.
        error = RCC_WaitForHSEStartUp();
        if(error == ERROR ) { // no external crystal
            return(EXT_ERR);
            }    
        RCC->CFGR |= (uint32_t)(RCC_CFGR_PLLSRC_HSE | RCC_CFGR_PLLMUL12 | RCC_CFGR_PLLDIV3);    
        }    

    /* Enable PLL */
    RCC->CR |= RCC_CR_PLLON;

    /* Wait till PLL is ready */
    do {
        PLLStatus = RCC->CR & RCC_CR_PLLRDY;
    } while((PLLStatus == 0) && (PLLStartUpCounter < PLL_STARTUP_TIMEOUT)); // wait for pll
    if(PLLStatus == 0) {
        return(PLL_ERR);
    }

    /* Select PLL as system clock source */
    RCC->CFGR &= (uint32_t)((uint32_t)~(RCC_CFGR_SW));
    RCC->CFGR |= (uint32_t)RCC_CFGR_SW_PLL;

    /* Wait till PLL is used as system clock source */
    while ((RCC->CFGR & (uint32_t)RCC_CFGR_SWS) != (uint32_t)RCC_CFGR_SWS_PLL)
    {
    }
    SystemCoreClockUpdate();                    // update SystemCoreClock var
    return(OK);
}

