/* Demo for mbed Library for FTDI FT800  Enbedded Video Engine "EVE"
 * based on Original Code Sample from FTDI
 * ported to mbed by Peter Drescher, DC2PD 2014
 * Released under the MIT License: http://mbed.org/license/mit */

#include "mbed.h"
#include "FT_Platform.h"

FT800 TFT(PA_7,PA_6,PA_5,PC_7,PB_4,PA_9);  // mosi, miso, sck, ss, int, pd     // the FT800 is connected to SPI 11-13

/***************************************************************************/
/* Show a Screen with Text for 5 seconds                                   */
/* A spinner shows the delay                                               */
/***************************************************************************/

ft_void_t Start_Screen(ft_char8_t *str)
{
    TFT.DLstart();                                         // start a new display command list
    TFT.DL(CLEAR_COLOR_RGB(255,255,255));      // set the clear color to white
    TFT.DL(CLEAR(1,1,1));                      // clear buffers -> color buffer,stencil buffer, tag buffer
    TFT.DL(COLOR_RGB(0x80,0x80,0x00));         // set current color
    TFT.Text((TFT.DispWidth/2), TFT.DispHeight/2, 31, OPT_CENTERX, str); // draw Text with font 31
    TFT.DL(COLOR_RGB(0xFF,0x00,0x00));         // change current color
    TFT.Spinner((TFT.DispWidth/2),TFT.DispHeight/4, 0,0);  // draw a animated spinner

    TFT.DL(DISPLAY());                         // Display the image
    TFT.Swap();                                            // Swap the current display list
    TFT.Flush_Co_Buffer();                                 // Download the command list into fifo

    TFT.WaitCmdfifo_empty();                               // Wait till coprocessor completes the operation
    TFT.Sleep(5000);                                       // Wait 5 s to show
}

// construct the screen and downloasd it to the LCD
void screen_1(unsigned int r,unsigned int g,unsigned int b)
{
    TFT.DLstart();                         // start a new display command list
    TFT.DL(CLEAR(1,1,1));                  // clear buffers -> color buffer,stencil buffer, tag buffer
    TFT.DL(COLOR_RGB(0xff,0xff,0xff));     // set current color to white
    TFT.DL(TAG(1));                        // assign TAG value 1
    TFT.FgColor(COLOR_RGB(0xff,0,0));      // forground color red
    TFT.Slider(140,81,310,14,0,r,255);     // slider for red
    TFT.DL(TAG(2));                        // assign TAG value 2
    TFT.FgColor(COLOR_RGB(0,0xff,0));      // forground color green
    TFT.Slider(140,133,310,14,0,g,255);    // slider for green
    TFT.DL(TAG(3));                        // assign TAG value 3
    TFT.FgColor(COLOR_RGB(0,0,0xff));      // forground color blue
    TFT.Slider(139,185,310,14,0,b,255);    // slider for blue
    TFT.DL(COLOR_RGB(0xff,0x00,0x00));     // set current color to red
    TFT.Text(82,69,30,0,"R");              // text R
    TFT.DL(COLOR_RGB(0x00,0xff,0x00));     // set current color to green
    TFT.Text(82,120,30,0,"G");             // text G
    TFT.DL(COLOR_RGB(0x00,0x00,0xff));     // set current color to blue
    TFT.Text(82,174,30,0,"B");             // text B
    TFT.DL(SCISSOR_XY(10,10));             // define area starting at 10,10
    TFT.DL(SCISSOR_SIZE(50,50));           // size 50,50
    TFT.DL(CLEAR_COLOR_RGB(r,g,b));        // set clear color to r,g,b
    TFT.DL(CLEAR(1,1,1));                  // fill the area
    TFT.DL(DISPLAY());                     // Display the image
    TFT.Swap();                            // Swap the current display list
    TFT.Flush_Co_Buffer();                 // Download the command list into fifo
    TFT.WaitCmdfifo_empty();               // Wait till coprocessor completes the operation
}

int main()
{
    unsigned int r = 0,g = 0,b = 0;
    ft_uint32_t TrackRegisterVal = 0;              // touch track

    Start_Screen("RGB DEMO START");                // Show start screen
    TFT.Calibrate();                               // calibrate the touch screen

    /* Set the tracker for the 3 sliders -  define the Area for touching */
    TFT.Track(131,63,330,48,1);                     // slider r
    TFT.Track(131,116,333,48,2);                    // slider g
    TFT.Track(131,168,330,48,3);                    // slider b
    TFT.Flush_Co_Buffer();                          // Download the commands into fifo
    TFT.WaitCmdfifo_empty();                        // Wait till coprocessor completes the operation
    screen_1(r,g,b);                                // paint screen

    /* the demo is updating the screen in a endless loop                                    */
    while(1) {
        ft_uint8_t tagval = 0;
        TrackRegisterVal = TFT.Rd32(REG_TRACKER);    // check if one of the tree Slider is touched
        tagval = TrackRegisterVal & 0xff;
        if(0 != tagval) {                            // touch -> get new rgb value
            if(1 == tagval) {                        // the red slider is touched
                r = TrackRegisterVal>>16;            // get the new value
                r = r *255/65536;                    // scale it down to 255
            } else if(2 == tagval) {                 // the green slider is touched
                g = TrackRegisterVal>>16;            // get new slider value
                g = g * 255/65536;                   // scale it down to 255
            } else if(3 == tagval) {                 // the blue slider is touched
                b = TrackRegisterVal>>16;            // get new slider value
                b = b * 255/65536;                   // scale it down to 255
            }
            screen_1(r,g,b);                         // paint new screen
            TFT.Sleep(10);                           // wait 10ms for next check
        }

    }  // end of display loop
}



