//Example of how use the Nucleo board with a Processing GUI program
/* Processing Code
import g4p_controls.*; // GUI library
import processing.serial.*; //serial library
int rosso, verde, blu;
int valoreSliderRosso,valoreSliderVerde,valoreSliderBlu;
String   porta;

Serial nucleoPort;
GCustomSlider sdrRosso, sdrVerde, sdrBlu; //  sliders creation
GButton btnRosso, btnVerde, btnBlu, btnConnetti;//buttons creation
GLabel Rosso, Verde, Blu, Porte; //labels creation
GDropList sceltaPorta;//port selector creation
void setup() {
  size(500, 320);  
  frame.setTitle("Nucleo RGB Color");
  //=============================================================
  // sliders
  sdrRosso = new GCustomSlider(this, 20, 30, 380, 50, null);
  sdrRosso.setShowDecor(false, false, true, true);
  sdrRosso.setNbrTicks(5);
  sdrRosso.setLimits(0, 0, 255);
  valoreSliderRosso=0;

  sdrVerde = new GCustomSlider(this, 20, 90, 380, 50, null);
  sdrVerde.setShowDecor(false, false, true, true);
  sdrVerde.setNbrTicks(5);
  sdrVerde.setLimits(0, 0, 255);
  valoreSliderVerde=0;
  
  sdrBlu = new GCustomSlider(this, 20, 150, 380, 50, null);
  sdrBlu.setShowDecor(false, false, true, true);
  sdrBlu.setNbrTicks(5);
  sdrBlu.setLimits(0, 0, 255);
  valoreSliderBlu=0;
  
  //=============================================================
  //label
  Rosso = new GLabel(this, 150, 10, 110, 50);
  Rosso.setText("Red");
  Rosso.setTextBold();  
  
  Verde = new GLabel(this, 150, 70, 110, 50);
  Verde.setText("Green");
  Verde.setTextBold(); 
  
  Blu = new GLabel(this, 150, 130, 110, 50);
  Blu.setText("Blue");
  Blu.setTextBold(); 
   
  Porte = new GLabel(this, 285, 180, 110, 50); 
  Porte.setText("Port Selection");
  Porte.setTextBold(); 
  
  //=============================================================
  //buttons
  btnRosso = new GButton(this, 20, 220, 80, 40, "Red");
  btnRosso.setTextBold();
  btnRosso.setLocalColorScheme(5);
  
  btnVerde  = new GButton(this, 110, 220, 80, 40, "Green");
  btnVerde.setTextBold();
  btnVerde.setLocalColorScheme(5);
  
  btnBlu = new GButton(this, 210, 220, 80, 40, "Blue");
  btnBlu.setTextBold();
  btnBlu.setLocalColorScheme(5);
  
  btnConnetti = new GButton(this, 300, 240, 80, 20, "Connect");
  btnConnetti.setTextBold();
  btnConnetti.setLocalColorScheme(7);  

  //=============================================================
  //serial port
  
  sceltaPorta = new GDropList(this,300,220,80,50,3);
  sceltaPorta.setItems(Serial.list(),0);//serial port aviable list
  porta = sceltaPorta.getSelectedText(); 
  nucleoPort = new Serial(this, porta, 9600); //serial port assignament
  //initialization
  while (nucleoPort.available()<0){
  setZero();}
  
}
void draw() {
 //background color
 background(68, 111, 216);
 //=============================================================
 //color boxes
 //red
  strokeWeight(2);
  stroke(104, 104, 255);
  rosso=sdrRosso.getValueI();
  fill(rosso, 0, 0);
  rect(400,40,40,40,7);

 //green
  strokeWeight(2);
  stroke(104, 104, 255);
  verde=sdrVerde.getValueI();
  fill(0, verde, 0);
  rect(400,100,40,40,7);

 //blue 
  strokeWeight(2);
  stroke(104, 104, 255);
  blu=sdrBlu.getValueI();
  fill(0, 0, blu);
  rect(400,160,40,40,7);
  
  //mixed
  strokeWeight(2);
  stroke(120, 120, 255);
  fill(rosso, verde, blu);
  rect(400,220,80,80,7);

if ((valoreSliderRosso == rosso) && (valoreSliderVerde == verde) && (valoreSliderBlu ==blu)){}
else{
      //send values
      mouseReleased();
    }
}

public void handleButtonEvents(GButton button, GEvent event) { 
  //buttons actions
  if (button == btnConnetti){
    porta = sceltaPorta.getSelectedText();
    nucleoPort = new Serial(this, porta, 9600);  println(porta);}
  else if (button == btnBlu){
    nucleoPort.write('B');
    nucleoPort.write(255);
        delay(100);
    nucleoPort.write('R');
    nucleoPort.write(0);
        delay(100);
    nucleoPort.write('G');
    nucleoPort.write(0);
      delay(100);}
  else if (button == btnVerde){
    nucleoPort.write('G');
    nucleoPort.write(255);
    delay(100);
    nucleoPort.write('R');
    nucleoPort.write(0);
    delay(100);    
    nucleoPort.write('B');
    nucleoPort.write(0);
    delay(100);}  
  else if (button == btnRosso){
    nucleoPort.write('R');
    nucleoPort.write(255);
    delay(100);
    nucleoPort.write('B');
    nucleoPort.write(0);
    delay(100);
    nucleoPort.write('G');
    nucleoPort.write(0);
    delay(100);
    }    

}
void setZero(){
  nucleoPort.write('G');
  nucleoPort.write(0);
  nucleoPort.write('R');  
  nucleoPort.write(0);
  nucleoPort.write('B');
  nucleoPort.write(0);
}
void mouseReleased(){
  nucleoPort.write('G');
  nucleoPort.write(verde);
  valoreSliderVerde=verde;  

  nucleoPort.write('R');  
  nucleoPort.write(rosso);
  valoreSliderRosso=rosso;

  nucleoPort.write('B');
  nucleoPort.write(blu);
  valoreSliderBlu=blu;}
*/
  
// Nucleo program
#include "mbed.h"
PwmOut red(D10);
PwmOut green(D11);
PwmOut blue(D12);
Serial Processing(USBTX, USBRX);
float mapRed,mapGreen,mapBlue;
char c;
int val;
float map(int value, float x_min, float x_max, float y_min, float y_max)    
{                                
    return (y_min + (((y_max - y_min)/(x_max - x_min)) * (value - x_min))); 
}   
int main(){
    red = 1;
    wait(0.2);
    red = 0;
    green = 1;
    wait(0.2);
    green = 0;
    blue = 1;
    wait(0.2);
    blue = 0;
    Processing.baud(9600);
    while(1){
    if (Processing.readable()==1){
        c=Processing.getc();
        if (c != 'E'){  
        if (c=='R'){
            val = Processing.getc();
            mapRed=map( val, 0, 255, 0, 1);
            red.write(mapRed);}
        else if ( c == 'G'){
            val = Processing.getc();
            mapGreen = map( val, 0, 255, 0, 1);
            green.write(mapGreen);}
        else if ( c == 'B'){
            val = Processing.getc();
            mapBlue = map( val, 0, 255, 0, 1);
            blue.write(mapBlue);}
        else {}
                        }
        else {}
            }         
        }    
    }
    