/*
 * Block.h
 *
 *  Created on: 16 Nov 2015
 *      Author: Chandan Siyag
 *
 *      Defines two classes:
 *      - Colour: is a colour object used for saving/retriving data from sensor. Can also do simple manipulations.
 *      - Block: class to save a block data, any new block that passes through, or hazardous block.
 */

#ifndef _block_h_
#define _block_h_

class Colour{
	public:
		Colour();
		Colour(float components[4]);
		Colour(const Colour& rhs);
		virtual ~Colour();
 		void printDescription();

		enum Components {Red = 0, Blue = 1, Green = 2, Alpha = 3};

		float components [4];

		float getAlpha() const {
				return components[Alpha];
			}

			void setAlpha(float alpha) {
				this->components[Alpha] = alpha;
			}

			float getBlue() const {
				return components[Blue];
			}

			void setBlue(float blue) {
				this->components[Blue] = blue;
			}

			float getGreen() const {
				return components[Green];
			}

			void setGreen(float green) {
				this->components[Green] = green;
			}

			float getRed() const {
				return components[Red];
			}

			void setRed(float red) {
				this->components[Red] = red;
			}
};

class Block {
public:
	// ENUM to help make code readable and reduce mistakes.
	enum Size {Small = 0, Big = 1};
	enum BlockColour {Wrong = -1, Red = 0, White = 1, Blue = 2, Green = 3, Orange = 4, Yellow = 5, Black = 6};

	Block();
	Block(Size size);
	Block(Size size, BlockColour blockColour);
	Block(Size size, Colour minColour, Colour maxColour, Colour averageColour);
	Block(const Block& rhs);
	virtual ~Block();

	Size size;
	Colour minColour;
	Colour maxColour;
	Colour averageColour;
	BlockColour colour;

 	void printDescription();
 private:
 	
};

#endif /* _block_h_ */
