//
// fpga.h
// Created by Chandan Siyag on 14/11/2015.
//
// All the things FPGA.
// Moving servos, getting break beam data.

#include "globals.h"

#ifndef _fpag_h_
#define _fpga_h_

enum BeamNumber { Top = 2, Bottom = 1 };

class FPGA{
public:
	FPGA();
	
	SortingServoPositions sortingServoPosition;
	StoppingServoPositions stoppingServoPosition;

	int checkForBlock();
	int checkForSize();

	void moveStoppingServo(StoppingServoPositions position);
	void moveSortingServo(SortingServoPositions position);
	void toggleStoppingServo();
	void toggleSortingServo();

	void resetStoppingServo();
	void resetSortingServo();
	void resetAllServos();

	virtual ~FPGA();

	int getBeamValue(int beamNumber);
	void moveServo(int servoNumber, int position);
};
#endif
