/*
 * Block.cpp
 *
 *  Created on: 16 Nov 2015
 *      Author: Chandan Siyag
 */

#include "Block.h"

Colour::Colour(){
	setRed(0);
	setBlue(0);
	setGreen(0);
	setAlpha(0);
}

Colour::~Colour(){

}

/// Create a new colour object from passed array of components.
Colour::Colour(float components[4]){
	for (int i = 0; i < sizeof(components)/sizeof(*components); i++){
		this->components[i] = components[i];
	}
}

/// Create new colour object from passed colour object.
/// Copies data, not a new pointer
Colour::Colour(const Colour& rhs){
	setRed(rhs.getRed());
	setBlue(rhs.getBlue());
	setGreen(rhs.getGreen());
	setAlpha(rhs.getAlpha());
}

/// Sends description to PC about itself.
/// Cannot be used here since it doesn't know about pc object. Defined in globals.h
void Colour::printDescription(){
//	pc.printf("Red: %.3f, Green: %.3f, Blue: %.3f, Clear: %.3f\n", this->component[0], this->component[1], this->component[2], this->component[3]);
}

Block::Block(){
	this->size = Small;
	this->minColour = Colour();
	this->averageColour = Colour();
	this->maxColour = Colour();
	this->colour = Block::Red;
}

/// Create new block object from passed size and colour
Block::Block(Size size, BlockColour blockColour){
	this->minColour = Colour();
	this->averageColour = Colour();
	this->maxColour = Colour();
	this->colour = blockColour;
	this->size = size;
}

/// Create new block with size and default colour
Block::Block(Size size) {
	// TODO Auto-generated constructor stub
	this->size = size;
	this->minColour = Colour();
	this->maxColour = Colour();
	this->averageColour = Colour();
}

/// Create new block object with passed properties
Block::Block(Size size, Colour minColour, Colour maxColour, Colour averageColour){
	this->size = size;
	this->minColour = Colour(minColour);
	this->maxColour = Colour(maxColour);
	this->averageColour = Colour(averageColour);
}

/// Copy block object to a new one.
Block::Block(const Block& rhs){
	minColour = Colour(rhs.minColour);
	maxColour = Colour(rhs.maxColour);
	averageColour = Colour(rhs.averageColour);
	size = rhs.size;
}

Block::~Block() {
	// TODO Auto-generated destructor stub
}

void Block::printDescription(){
	
}
