
//
// globals.h
// Created by Chandan Siyag on 13/11/2015.
//
// Includes all the functions, variables, objects that need to be accessed accross the classes/files.
#ifndef _globals_h_
#define _globals_h_

#include "Block.h"
#include "mbed.h"

// Forward declared classes
class FPGA;
class TCS3472_I2C;
class MCP23017;
class WattBob_TextLCD;

// External global variables
extern mbed::Serial pc;
extern MCP23017 *i2cport;
extern int kDefaultBaudRate;
extern WattBob_TextLCD *lcd;
//extern SerialBase gParity;
extern int gStopBits;
extern bool connectedToPC;
extern bool runServoTest;
extern bool runBreakBeamTest;
extern bool runColourSensorTest;
extern bool getColourSensorValue;
extern bool getBlockColourValue;
extern float gIntegrationTime;
extern int gToggleServoNumber;
extern int errorMultiplier;
extern int hazReadingCount;
extern bool setNewHazBlock;

// Constants
const int kCommandBufferSize = 80;
const int kSmallBufferSize = 5;
const float kServoWait = 0.20;

// More external globals vars
extern float currentMinError[3];
extern float currentMaxError[3];
extern bool pcModeChanged;
#define FOREVER for(;;)

// More constants and enums
const char CommandTypeValue [3] = {'!', '?', ':'};
const char kCommandTerminator = ';';
enum CommandTypeRaw { InvalidType = -1, Set = 0, Query = 1, Reply = 2 };

// Red block values
const float kMinRedBlock[4] = {4.812, 2.286, 1.316, 1};
const float kMaxRedBlock[4] = {5.474, 3.105, 1.429, 1};
const float kAverageRedBlock[4] = {5.25134482758621, 2.85965517241379, 1.35858620689655, 1};
const float kMinRedError[3] = { 0.389641483105392, 0.383777881434993, 0.0610744881279823};
const float kMaxRedError[3] = { 0.238327377883225, 0.139481384106522, 0.0612648605358003};

// Other colour blocks
const float kMinError[7][3] = {
		{ 0.389641483105392, 0.383777881434993, 0.0500744881279823}, // Red
		{ 0.0359779720380292, 0.0461476412271348, 0.0391255334092747 }, // White
		{ 0.050917996923305, 0.109422428771797, 0.0665409549163153 }, // Blue
		{ 0.0880138969310943, 0.0743612766304789, 0.143658023826209 }, // Green
		{ 0.517256339090836, 0.504177829914356, 0.0752212389380535 }, // Orange
		{ 0.092903676196678, 0.125407698975651, 0.107444827572802 }, // Yellow
		{ 0, 0, 0} // TODO: Add Black
};

const float kMaxError[7][3] = {
		{ 0.238327377883225, 0.139481384106522, 0.0502648605358003},
		{ 0.0231629905458534, 0.0382894017850168, 0.0244999380271382 }, // White
		{ 0.312890306667189, 0.361950218761122, 0.307500801104292 }, // Blue
		{ 0.532136653155761, 0.0508203411966372, 0.0469516468114928 }, // Green
		{ 0.215383578992752, 0.114324911398194, 0.0350882137421786 }, // Orange
		{ 0.055956916957788, 0.0732559590665169, 0.0515512811043425 }, // Yellow
		{ 0, 0, 0} // TODO: Add black
};

const float kAverageValues[7][4] = {
		{5.25134482758621, 2.85965517241379, 1.35858620689655, 1},
		{ 4.10882727272727, 1.39749090909091, 1.54026363636364, 1 },
		{ 2.5782808988764, 0.536730337078651, 0.911662921348315, 1 },
		{ 4.60533333333333, 1.13435185185185, 2.1405, 1 },
		{ 6.51070175438596, 3.52949122807018, 1.86747368421053, 1 },
		{ 6.81846, 2.96481, 2.57239, 1 },
		{ 0, 0, 0, 1 }
};

// External global objects
extern Block defaultHazBlock;
extern Block _HazBlock;
extern FPGA *fpga;

extern TCS3472_I2C rgbSensor;

// Enums to help make code more readable and easier to edit
enum Servos {Stopping = 1, Sorting = 2};
enum StoppingServoPositions {Stop = 0, Go = 1};
enum SortingServoPositions {NonHaz = 0, Haz = 1};
enum Controls { Start = 0, Pause = 1};
enum PCModes { None = -1, Normal = 0, Maintanence = 1};

// External variables
extern PCModes currentMode;
extern Controls currentState;

// Global functions
void DefaultHazBlock();

int readSwitches();
bool displayAbortDialog();
void displayPCStatus();

void connectToPC(CommandTypeRaw typeRaw=Set);
void disconnectToPC(CommandTypeRaw typeRaw=Set);
void hazBlock(CommandTypeRaw typeRaw);
void getCurrentBlock(CommandTypeRaw typeRaw=Query);

void setIntegrationTimeTo(float integrationTime);
void previewOnPC(bool on);
void testColourSensor(Controls state);

void testServos(Controls state);
void resetServos();

void getPortInfo();
void setPortBaudRate(int baudRate);
void setPortParity(int parity);

void testBreakBeams(Controls state);

void printColourDescription(Colour colour);
void printBlockDescription(Block block);
#endif
