//
// fpga.cpp
// Created by Chandan Siyag on 14/11/2015.

#include "fpga.h"
#include "mbed.h"

// Macro to sync MBED and FPGA clocks
#define CLK() bbClk.write(1); wait(0.000001); bbClk.write(0); wait(0.000001);

DigitalOut bbClk(p11);
DigitalOut bbRst(p12);
DigitalOut bbOut(p13);
DigitalIn bbIn(p14);
int brkBbm_1, brkBbm_2, brkBbm_3, brkBbm_4, brkBbm_5, brkBbm_6, brkBbm_7, brkBbm_8;

FPGA::FPGA(){

}

FPGA::~FPGA(){

}

/// Function that checks first IR sensor to detect if block in shoot
/// @return 1 if sensor beam broken, 0 otherwise
int FPGA::checkForBlock(){
	return this->getBeamValue(1);
}

/// Function that checks if block is also breaking the second IR sensor.
/// @result 1 if it's large, 0 otherwise
int FPGA::checkForSize(){
	return this->getBeamValue(2);
}

/// No longer used since idea of using top servo was discontinued.
/// Moves the stopping servo in the "hopper" to stop blocks from falling
void FPGA::moveStoppingServo(StoppingServoPositions position) {
	if (position == Stop){
		bbRst.write(0);
		CLK();
		bbRst.write(1);
		CLK();          //Reset finish
		bbOut.write(1);
		CLK();
		bbOut.write(1);
		CLK();
		bbOut.write(0);
		CLK();          // Address finish

		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(1);
		CLK();
		bbOut.write(1);
		CLK();
		bbOut.write(0);
		CLK();          // Position finish

		bbOut.write(1);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();          // Number finish
		bbOut.write(0);
	}else if (position == Go){
		bbRst.write(0);
		CLK();
		bbRst.write(1);
		CLK();          //Reset finish
		bbOut.write(1);
		CLK();
		bbOut.write(1);
		CLK();
		bbOut.write(0);
		CLK();          // Address finish

		bbOut.write(1);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();          //Position finish

		bbOut.write(1);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();
		bbOut.write(0);
		CLK();          //Number finish
		bbOut.write(0);
	}
	this->stoppingServoPosition = position;
}

/// Moves the servoe which decides which basket block should go into i.e. haz or not
void FPGA::moveSortingServo(SortingServoPositions position){
	if (position == Haz){
			// HAZ = 26
            bbRst.write(0);
            CLK();
            bbRst.write(1);
            CLK();          //Reset finish
            bbOut.write(1);
            CLK();
            bbOut.write(1);
            CLK();
            bbOut.write(0);
            CLK();          // Address finish
            bbOut.write(0);
            CLK();
            bbOut.write(1);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(1);
            CLK();
            bbOut.write(1);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0); 
            CLK();          //Position finish
            bbOut.write(0);
            CLK();
            bbOut.write(1);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0);
            CLK();          //Number finish
            bbOut.write(0);
	}else if (position == NonHaz){
		// NON-HAZ = 60
            bbRst.write(0);
            CLK();
            bbRst.write(1);
            CLK();          //Reset finish
            bbOut.write(1);
            CLK();
            bbOut.write(1);
            CLK();
            bbOut.write(0);
            CLK();          // Address finish
            bbOut.write(0);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(1);
            CLK();
            bbOut.write(1);
            CLK();
            bbOut.write(1);
            CLK();
            bbOut.write(1);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0); 
            CLK();          //Position finish
            bbOut.write(0);
            CLK();
            bbOut.write(1);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0);
            CLK();
            bbOut.write(0);
            CLK();          //Number finish
            bbOut.write(0);
	}
	this->sortingServoPosition = position;
}

/// Toggles stopping servo based on current position.
/// Used in the servo test mode.
void FPGA::toggleStoppingServo(){
	if (this->stoppingServoPosition == Go)
		this->moveStoppingServo(Stop);
	else if (this->stoppingServoPosition == Stop)
		this->moveStoppingServo(Go);
}

/// Toggles sorting servo based on current position
/// Used in the servo test mode.
void FPGA::toggleSortingServo() {
	if (this->sortingServoPosition == Haz)
		this->moveSortingServo(NonHaz);
	else if (this->sortingServoPosition == NonHaz)
		this->moveSortingServo(Haz);
}

/// Place holder function. Since all servo move to their default position after kServoWaitTime
///Reset the stopping servo to default position
void FPGA::resetStoppingServo(){

}
/// Place holder function. Since all servo move to their default position after kServoWaitTime
/// Reset the sorting servo to default position
void FPGA::resetSortingServo(){

}
/// Place holder function. Since all servo move to their default position after kServoWaitTime
/// Reset both servos, simply calls their respective reset methods.
void FPGA::resetAllServos(){
	resetSortingServo();
	resetStoppingServo();
}

/// Get beam value i.e. high = 1, low = 0;
/// Beam number Top = 1, Bottom = 2. USE ENUMS to avoid mistakes.
int FPGA::getBeamValue(int beamNumber){
	// Return 0 or 1 value for break beam
	bbRst.write(0);
	CLK();
	bbRst.write(1);
	CLK();          //Reset finish
	bbOut.write(1);
	CLK();
	bbOut.write(0);
	CLK();
	bbOut.write(1);
	CLK();          //Address finish
	CLK();
	brkBbm_1 = bbIn.read();
	CLK();
	brkBbm_2 = bbIn.read();
	CLK();
	brkBbm_3 = bbIn.read();
	CLK();
	brkBbm_4 = bbIn.read();
	CLK();
	brkBbm_5 = bbIn.read();
	CLK();
	brkBbm_6 = bbIn.read();
	CLK();
	brkBbm_7 = bbIn.read();
	CLK();
	brkBbm_8 = bbIn.read();
	CLK();                  //Break beam data recieved and saved
	bbOut.write(0);

	if (beamNumber == 1) {
		return brkBbm_1;
	} else if (beamNumber == 2) {
		return brkBbm_2;
	}
	return -1;
}

/// Place holder for more servos that can be attached.
/// Currently both servo have their own designated methods.
void FPGA::moveServo(int servoNumber, int position){

}
