//
// commander.h
// Created by Chandan Siyag on 14/11/2015.
//
// Parses and executes commands received from the PC.
//

#include "globals.h"

#ifndef _commander_h_
#define _commander_h_

const int kMaxCommandCount = 10;
enum CommandObjectRaw { InvalidObject = -1, MBED = 0, PC = 1, ColourSensor = 2, Servos = 3, Port = 4, BreakBeam = 5 };
extern std::string CommandObjectValue [6];
extern std::string CommandObjectCommandsValue [6][kMaxCommandCount];


class Commander {
public:
	Commander();
	
	CommandTypeRaw typeRaw;
	char typeChar;
	CommandObjectRaw objectRaw;
	std::string object;
	std::string command[kMaxCommandCount - 1];
	std::string commandValue[kMaxCommandCount - 1];
	int commandIndex[kMaxCommandCount -1];
	bool replyCommands;
	
	void decodeCommand(CommandTypeRaw type);
	std::string description();
	
	virtual ~Commander();
	
private:
	void readCommandObject();
	bool readCommand(CommandObjectRaw objectRaw);
	void executeCommand();
	void resetVariables();
};

#endif
