/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "iBeaconService.h"

/**
 * For this demo application, populate the beacon advertisement payload
 * with 2 AD structures: FLAG and MSD (manufacturer specific data).
 *
 * Reference:
 *  Bluetooth Core Specification 4.0 (Vol. 3), Part C, Section 11, 18
 */

BLEDevice ble;

/**
 * The Beacon payload has the following composition:
 * 128-Bit / 16byte UUID = E2 0A 39 F4 73 F5 4B C4 A1 2F 17 D1 AD 07 A9 61
 * Major/Minor  = 0x1122 / 0x3344
 * Tx Power     = 0xC8 = 200, 2's compliment is 256-200 = (-56dB)
 *
 * Note: please remember to calibrate your beacons
 * TX Power for more accurate results.
 */
 /*
const uint8_t uuid[] = {0xE2, 0x0A, 0x39, 0xF4, 0x73, 0xF5, 0x4B, 0xC4,
                        0xA1, 0x2F, 0x17, 0xD1, 0xAD, 0x07, 0xA9, 0x61
                       };
*/                       
const uint8_t uuid[] = {0x4A, 0x5E, 0xB0, 0x51, 0xAD, 0x11, 0x03, 0x55, 
                        0xDE, 0x0B, 0x61, 0x89, 0x90, 0x9F, 0x8F, 0xFF
                       };
uint16_t majorNumber = 1122;
uint16_t minorNumber = 3344;
uint16_t txPower = 0xC8;

int main(void)
{
    ble.init();

    iBeaconService ibeacon(ble, uuid, majorNumber, minorNumber, txPower);

    ble.setAdvertisingInterval(1000); /* 1000ms. */
    ble.startAdvertising();

    while(1) {
        ble.waitForEvent(); // allows or low power operation
    }
}
