/* mbed Microcontroller Library
 * Copyright (c) 2006-2014 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "BLE.h"
#include "BatteryService.h"

BLE  ble;

DigitalOut led1(LED1, 1);
Ticker t;

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    printf("Disconnected handle %u!\n\r", handle);
    printf("Restarting the advertising process\n\r");
    ble.startAdvertising();
}

void blink(void)
{
    led1 = !led1;
}

int main(void)
{
    uint8_t batteryLevel = 50;
    t.attach(blink, 1.0f);

    printf("Initialising the nRF51822\n\r");

    ble.init();
    ble.onDisconnection(disconnectionCallback);

    BatteryService batteryService(ble, batteryLevel);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(1000); /* 1000ms; in multiples of 0.625ms. */
    ble.startAdvertising();

    while (true) {
        ble.waitForEvent(); // this will return upon any system event (such as an interrupt or a ticker wakeup)

        // the magic battery processing
        batteryLevel++;
        if (batteryLevel > 100) {
            batteryLevel = 20;
        }

        batteryService.updateBatteryLevel(batteryLevel);
    }
}
