#include "mbed.h"
#include "ft5336.h"
#include "stm32746g_discovery.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "logo.h"

void drawImage_logo(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)logo.data;
    while(y < logo.height) {
        while(x < logo.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

TS_StateTypeDef State;
TS_TouchEventTypeDef event;
DigitalOut buzer(PG_6);
I2C i2c(PB_9,PB_8); // initialisation des broches I2C



int main()
{

    char readdata[6] = {};
    char writedata[6] = {};
    int frequence = 100000;
    int x = 0;
    int y = 0;
    int read = 0;
    uint8_t adresse = 42; // adresse du capteur
    uint8_t coorX = 100;
    uint8_t coorY = 100;
    char buf[20] = {0};
    char buf2[20] = {0};
    char buffer[10] = {};
    char bufvalue[10] = {};
    int MSB = 0; // most significant bit
    int LSB = 0; // less signifiicant bit
    int ppm = 0;
    int etat = 1;

    BSP_LCD_Init(); // initialisation du LCD
    BSP_TS_Init(BSP_LCD_GetXSize(),BSP_LCD_GetYSize()); // initialisation du touch screen
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    i2c.frequency(frequence); // frequence de communication imposee par le maître


    int i = 0;


    BSP_LCD_Clear(LCD_COLOR_WHITE);

    while (1) {



        switch(etat)

        {

            case 0 :

                writedata[0] = 0x04;
                writedata[1] = 0x13;
                writedata[2] = 0x8B;
                writedata[3] = 0x00;
                writedata[4] = 0x01;

                i2c.write(adresse, writedata, 6);  // requête pour obtenir les mesures du capteur
                HAL_Delay(7);
                read = i2c.read(adresse, readdata, 5); // stock les mesures dans le tableau readdata
                HAL_Delay(10);

                switch(read) {

                    case 0:
                        drawImage_logo(0,0);
                        MSB = (int)readdata[2];                     // affecte la valeur du MSB
                        LSB = (int)readdata[3];                     // affecte la valeur du LSB
                        ppm = MSB*256+LSB;                          // calcul pour obtenir la valeur en ppm
                        sprintf(bufvalue,"%d",ppm);                 // conversion d'un nombre en caractère
                        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                        BSP_LCD_SetTextColor(LCD_COLOR_DARKBLUE);
                        BSP_LCD_DisplayStringAt(40, 100, (uint8_t *)bufvalue, CENTER_MODE);
                        BSP_LCD_DisplayStringAt(120, 100, (uint8_t *)"ppm", CENTER_MODE);

                        if(ppm > 1500) {

                            BSP_LCD_Clear(LCD_COLOR_WHITE);
                            BSP_LCD_DisplayStringAt(0, 130, (uint8_t *)"Evacuer la salle", CENTER_MODE);
                            BSP_LCD_DisplayStringAt(0, 100, (uint8_t *)bufvalue, CENTER_MODE);
                            BSP_LCD_DisplayStringAt(90, 100, (uint8_t *)"ppm", CENTER_MODE);
                            BSP_LCD_SetTextColor(LCD_COLOR_RED);
                            BSP_LCD_DisplayStringAt(0, 160, (uint8_t *)"seuil de CO2 mauvais", CENTER_MODE);
                            BSP_LCD_DisplayStringAt(-165, 207, (uint8_t *)"<-", CENTER_MODE);
                            drawImage_logo(0,0);
                            buzer.write(1);
                        }

                        else if(ppm > 600 && ppm < 1000) {

                            BSP_LCD_Clear(LCD_COLOR_WHITE);
                            BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                            BSP_LCD_SetTextColor(LCD_COLOR_LIGHTBLUE );
                            BSP_LCD_DisplayStringAt(0, 150, (uint8_t *)"qualite air moderee", CENTER_MODE);
                            BSP_LCD_DisplayStringAt(40, 100, (uint8_t *)bufvalue, CENTER_MODE);
                            BSP_LCD_DisplayStringAt(120, 100, (uint8_t *)"ppm", CENTER_MODE);
                            BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
                            BSP_LCD_DisplayStringAt(-165, 207, (uint8_t *)"<-", CENTER_MODE);
                            drawImage_logo(0,0);
                        }

                        else if(ppm > 400 && ppm < 600) {

                            BSP_LCD_Clear(LCD_COLOR_WHITE);
                            BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                            BSP_LCD_SetTextColor(LCD_COLOR_DARKBLUE);
                            BSP_LCD_DisplayStringAt(0, 100, (uint8_t *)bufvalue, CENTER_MODE);
                            BSP_LCD_DisplayStringAt(80, 100, (uint8_t *)"ppm", CENTER_MODE);
                            BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
                            BSP_LCD_DisplayStringAt(0, 150, (uint8_t *)"qualite air moyen", CENTER_MODE);
                            BSP_LCD_DisplayStringAt(-165, 207, (uint8_t *)"<-", CENTER_MODE);
                            drawImage_logo(0,0);

                        }

                        else if(ppm <= 400) {

                            BSP_LCD_Clear(LCD_COLOR_WHITE);
                            BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                            BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
                            BSP_LCD_DisplayStringAt(0, 100, (uint8_t *)bufvalue, CENTER_MODE);
                            BSP_LCD_DisplayStringAt(80, 100, (uint8_t *)"ppm", CENTER_MODE);
                            BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
                            BSP_LCD_DisplayStringAt(0, 150, (uint8_t *)"qualite air excellente", CENTER_MODE);
                            BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                            BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
                            BSP_LCD_DisplayStringAt(-165, 207, (uint8_t *)"<-", CENTER_MODE);
                            drawImage_logo(0,0);
                        }


                        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                        BSP_LCD_SetTextColor(LCD_COLOR_DARKBLUE);
                        BSP_LCD_DisplayStringAt(0, 0, (uint8_t *)"QUALITE AIR", CENTER_MODE);

                        HAL_Delay(1000);
                        BSP_TS_GetState(&State);        // initialise touch screen
                        coorX = State.touchX[0];        // récupére les coordonnées en x
                        coorY = State.touchY[0];        // récupére les coordonnées en y
                        BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
                        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                        BSP_LCD_DisplayStringAt(-165, 207, (uint8_t *)"<-", CENTER_MODE);

                        if(coorY >= 190 && coorY <= 250 && coorX >= 25 && coorX <= 70) {
                            BSP_LCD_DisplayStringAt(100, 50, (uint8_t *)"affichage des mesures", CENTER_MODE);
                            BSP_LCD_Clear(LCD_COLOR_WHITE);
                            buzer.write(0);  // eteind le buzer
                            etat = 1;
                        }

                        break;

                    case 1:

                        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                        BSP_LCD_SetTextColor(LCD_COLOR_DARKBLUE);
                        BSP_LCD_DisplayStringAt(50, 180, (uint8_t *)"I2C read nothing: ", CENTER_MODE);

                        break;

                }


                ppm = 0; // met la valeur mesuré
                break;

            case 1:


                BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                BSP_LCD_SetTextColor(LCD_COLOR_DARKBLUE);
                BSP_LCD_DisplayStringAt(0, 0, (uint8_t *)"QUALITE AIR", CENTER_MODE);
                drawImage_logo(0,0);            // logo iut
                HAL_Delay(1000);
                BSP_TS_GetState(&State);        // initialise touch screen
                coorX = State.touchX[0];
                coorY = State.touchY[0];
                BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
                BSP_LCD_DrawRect(180, 190, 120,40);
                BSP_LCD_DisplayStringAt(0, 200, (uint8_t *)"mesure", CENTER_MODE);

                if(coorY >= 180 && coorY <= 220 && coorX >= 220 && coorX <= 240) {
                    BSP_LCD_DisplayStringAt(100, 50, (uint8_t *)"mesures CO2 en ppm ", CENTER_MODE);
                    etat = 0;
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
                }

                else {
                    etat = 1;
                }

                HAL_Delay(1000);
                BSP_TS_ITClear();
                BSP_TS_ResetTouchData(&State);


                break;
        }






    }
}
