#include "mbed.h"
#include "bq79606.h"

// - - - PIN CONFIGURATION - - -

//DigitalIn bmsFault(PB_4);
DigitalOut bmsWakeUp(PB_4);
DigitalOut LV_ON(PC_6);

// - - - UART CONFIGURATION - - -
Serial bms(PC_12, PD_2, 250000); //UART ka BMS Slaveu
Serial pc1(USBTX, USBRX, 9600);
//Serial pc1(PC_10, PC_11, 9600);//PC_10, PC_11,9600); //UART ka PCu Serijskom monitoru

CAN can1(PB_8, PB_9, 500000);
CANMessage message1;
        

BYTE recBuff[1024];
volatile int recLen=0;
volatile int expected=0;
volatile bool full = false;
volatile int rdLen=0;
int counter = 0;
volatile int devStat = 0;
volatile int cbRun = 1;
volatile int cbDone = 0;

uint8_t pFrame1[(MAXBYTES+6)*TOTALBOARDS];

void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    //pc1.printf("* * *    Uspesan PRIJEM!     * * *\n");
    
        //pc1.printf("rec = %d", c);
        recBuff[recLen++] = bms.getc();
        if(expected==0) expected = recBuff[0]+7; //prvi bajt je (broj data - 1), +1 device id, +2 reg address, +2 CRC
        //pc1.printf("Prva rec = %d", recBuff[0]); 
        if(expected == recLen){
            //pc1.printf("\n\n- - - USAO U EXPECTED - - -\n"); 
            full = true;
            rdLen = expected;
            expected = 0;
            recLen = 0;
        }
        
    
    //full = true;
    //recLen = 0;
    //rdLen = 17; //samo test - nebitno koji broj
}

void waitFrame(){
    while(!full);
    //wait(2);
    full=false;
    pc1.printf("\n%d\n", rdLen);
    for(int i = 0;i<rdLen;i++){
        pc1.printf("%X ",recBuff[i]);
    }
    
    pc1.printf("\n\n- - - VOLTAGE - - -\n"); 
    message1.id = 0x71;
    int j = 0;
    for(int i = 4; i < recBuff[0] + 4; i += 2){
        int voltage = recBuff[i+1];   //LSB
        voltage |= (recBuff[i]) << 8; //MSB
        double vol = voltage*0.0001907349;
        //double vol = ((double)voltage)/65536.0 * 5.0;
        pc1.printf("CELL[%d] = %6.2f V\n", i/2-1, vol);
        
        message1.data[j++] = recBuff[i];
        
    }
    can1.write(message1);
      
    pc1.printf("\n");
}


void waitFrameTemp(){
    while(!full);
    //wait(2);
    full=false;
    pc1.printf("****** TEMPERATURA *****");
    pc1.printf("\n%d\n", rdLen);
    for(int i = 0;i<rdLen;i++){
        pc1.printf("%X ",recBuff[i]);
    }
        int voltage = recBuff[5];   //LSB
        voltage |= (recBuff[4]) << 8; //MSB
        double vol = voltage*0.0001907349;
        //double vol = ((double)voltage)/65536.0 * 5.0;
        pc1.printf("temp1  = %f V\n", vol);
   
}
void waitFrameResponse(){
    while(!full);
    full = false;
    for(int i = 0;i < rdLen; i++){
        pc1.printf("%X ", recBuff[i]);
    }
    pc1.printf("\n");
}
void cellBalanceStart()
{
    cbRun = 1;
    cbDone = 0;
    WriteReg(0, CB_CONFIG, 0xFA, 1, FRMWRT_ALL_NR); // Odds then Evens, continue regardless of fault condition, 30sec, seconds
    
    WriteReg(0, CB_DONE_THRESHOLD, 0x5F, 1, FRMWRT_ALL_NR); // Thresh hold set to value 3.6V, CBDONE comparators enabled
    //Enabling the CBDONE voltage threshold overrides the OVUV function and pauses it.
    
    WriteReg(0, CB_CELL1_CTRL, 0xBC, 1, FRMWRT_ALL_NR);//cell 1- 1 minute balance timer
    WriteReg(0, CB_CELL2_CTRL, 0xBC, 1, FRMWRT_ALL_NR);//cell 2- 1 minute balance timer
    WriteReg(0, CB_CELL3_CTRL, 0xBC, 1, FRMWRT_ALL_NR);//cell 3- 1 minute balance timer
    WriteReg(0, CB_CELL4_CTRL, 0xBC, 1, FRMWRT_ALL_NR);//cell 3- 1 minute balance timer
    
    WriteReg(0, CONTROL2, 0x30, 1, FRMWRT_ALL_NR);//BAL_GO set to 1, and TSREF enabled
    wait_us(100);
    pc1.printf("Setupovano balansiranje\n");
    while (cbRun)
    {
        ReadReg(0, DEV_STAT, pFrame1, 1 , 0, FRMWRT_ALL_R);
        wait(1);
        devStat = recBuff[4];
        cbRun = (devStat & 0x10) >> 4;
        wait_us(500);
        if (!cbRun)
        {
            pc1.printf("DEV STAT = %d\n", devStat);
            pc1.printf("CBRUN = %d\n", cbRun);
            //wait(10);
        }
    }
    
    while(!cbDone)
    {
        ReadReg(0, DEV_STAT, pFrame1, 1 , 0, FRMWRT_ALL_R);
        wait(1);
        devStat = recBuff[4];
        cbDone = (devStat & 0x40) >> 6;
        wait_us(500);
        if (cbDone)
        {
            pc1.printf("DEV STAT = %d\n", devStat);
            pc1.printf("CBDONE = %d\n", cbDone);
            //wait(10);
        }
    }
    // Cleanup
    WriteReg(0, CONTROL2, 0x00, 1, FRMWRT_ALL_NR);//Reset
    WriteReg(0, CB_DONE_THRESHOLD, 0x20, 1, FRMWRT_ALL_NR);
}
int main(){
    pc1.printf("Main ulazak\n");
    bms.attach(&callback);
    pc1.printf("Main after attacha\n");
    Wake79606();
    pc1.printf("woken up\n");
    //DigitalOut(PA_0, 0);
    //DigitalOut(PA_1, 0);
    //wait(1);
    //DigitalOut(PA_0, 1);
    //DigitalOut(PA_1, 1);
    //bms(PA_0, PA_1, 250000);
    bms.baud(10);
    bms.send_break();
    bms.baud(250000);
    //wait_ms(500);
    //bms.clear_break();
    
    wait(2); //marta rekla da mozda treba da se doda wait
    AutoAddress();
    
    
    //WriteReg(0, COMM_CTRL, 0x343C, 2, FRMWRT_ALL_NR); //mask GPIO faults
    
    wait(2);
    init();
    /*WriteReg(0, COMM_TO, 0x00, 1, FRMWRT_ALL_NR); //disable COMM timeout because printf takes a long time between reads
    WriteReg(0, SYSFLT1_FLT_RST, 0xFFFFFF, 3, FRMWRT_ALL_NR);   //reset system faults
    WriteReg(0, SYSFLT1_FLT_MSK, 0xFFFFFF, 3, FRMWRT_ALL_NR);   //mask system faults (so we can test boards and not worry about triggering these faults accidentally)

    //SET UP MAIN ADC
    WriteReg(0, CELL_ADC_CTRL, 0x3F, 1, FRMWRT_ALL_NR);     //enable conversions for all cells
    WriteReg(0, CELL_ADC_CONF2, 0x08, 1, FRMWRT_ALL_NR);    //set continuous ADC conversions, and set minimum conversion interval
    WriteReg(0, CONTROL2, 0x01, 1, FRMWRT_ALL_NR);          //CELL_ADC_GO = 1
    wait_ms(5);*/
    
    //bmsWakeUp = 0;
    pc1.printf("Pre while-a\n");
    LV_ON = 1;
    while (1) {
        pc1.printf("Main Code \n");
                
        pc1.printf("Board 0 \n");
        
        
        
        
        wait(2);
        //while(bms.readable()) bms.getc();
        int rdLen = ReadReg(0, VCELL1H , pFrame1, 6 , 0, FRMWRT_ALL_R); //6 bajtova jer cita od adrese VCELL1H po dva bajta za svaki kanal (ima 3 kanala)
        
        
        
        waitFrame();
        
        WriteReg(0, CONTROL2, 0x02, 1, FRMWRT_ALL_NR);
        ReadReg(0, AUX_GPIO1H, pFrame1, 2 , 0, FRMWRT_ALL_R); 
        
        waitFrameTemp();
        
        cellBalanceStart();
        
        //slanje zahteva za GRESKAMA
        //ReadReg(0, 0x52, &wTemp, 2, 0); // 0ms timeout
        //waitFrameResponse();
        

    }
    
    
    
}