#include "mbed.h"
#include <string>
using std::string;
//PITATI GDE SE DEFINISU FRAMEOVI
#define FRMWRT_SGL_R    0x80 // single device read with response
#define FRMWRT_SGL_NR   0x90 // single device write without response
#define FRMWRT_ALL_R    0xC0 // general broadcast read with response
#define FRMWRT_ALL_NR   0xD0 // general broadcast write without response 

#define CONFIG          0x001
#define COMM_CTRL       0x20
#define ECC_TEST        0x11D
#define CONTROL1        0x105
#define COMM_TO         0x23
#define TX_HOLD_OFF     0x22
#define CONTROL2        0x106

typedef unsigned char BYTE;
//CRC TABELA REKLA MARTA DA JE ISTA, PROVERITI!
const uint16_t crc16_table[256] = {
    0x0000, 0xC0C1, 0xC181, 0x0140, 0xC301, 0x03C0, 0x0280, 0xC241,
    0xC601, 0x06C0, 0x0780, 0xC741, 0x0500, 0xC5C1, 0xC481, 0x0440,
    0xCC01, 0x0CC0, 0x0D80, 0xCD41, 0x0F00, 0xCFC1, 0xCE81, 0x0E40,
    0x0A00, 0xCAC1, 0xCB81, 0x0B40, 0xC901, 0x09C0, 0x0880, 0xC841,
    0xD801, 0x18C0, 0x1980, 0xD941, 0x1B00, 0xDBC1, 0xDA81, 0x1A40,
    0x1E00, 0xDEC1, 0xDF81, 0x1F40, 0xDD01, 0x1DC0, 0x1C80, 0xDC41,
    0x1400, 0xD4C1, 0xD581, 0x1540, 0xD701, 0x17C0, 0x1680, 0xD641,
    0xD201, 0x12C0, 0x1380, 0xD341, 0x1100, 0xD1C1, 0xD081, 0x1040,
    0xF001, 0x30C0, 0x3180, 0xF141, 0x3300, 0xF3C1, 0xF281, 0x3240,
    0x3600, 0xF6C1, 0xF781, 0x3740, 0xF501, 0x35C0, 0x3480, 0xF441,
    0x3C00, 0xFCC1, 0xFD81, 0x3D40, 0xFF01, 0x3FC0, 0x3E80, 0xFE41,
    0xFA01, 0x3AC0, 0x3B80, 0xFB41, 0x3900, 0xF9C1, 0xF881, 0x3840,
    0x2800, 0xE8C1, 0xE981, 0x2940, 0xEB01, 0x2BC0, 0x2A80, 0xEA41,
    0xEE01, 0x2EC0, 0x2F80, 0xEF41, 0x2D00, 0xEDC1, 0xEC81, 0x2C40,
    0xE401, 0x24C0, 0x2580, 0xE541, 0x2700, 0xE7C1, 0xE681, 0x2640,
    0x2200, 0xE2C1, 0xE381, 0x2340, 0xE101, 0x21C0, 0x2080, 0xE041,
    0xA001, 0x60C0, 0x6180, 0xA141, 0x6300, 0xA3C1, 0xA281, 0x6240,
    0x6600, 0xA6C1, 0xA781, 0x6740, 0xA501, 0x65C0, 0x6480, 0xA441,
    0x6C00, 0xACC1, 0xAD81, 0x6D40, 0xAF01, 0x6FC0, 0x6E80, 0xAE41,
    0xAA01, 0x6AC0, 0x6B80, 0xAB41, 0x6900, 0xA9C1, 0xA881, 0x6840,
    0x7800, 0xB8C1, 0xB981, 0x7940, 0xBB01, 0x7BC0, 0x7A80, 0xBA41,
    0xBE01, 0x7EC0, 0x7F80, 0xBF41, 0x7D00, 0xBDC1, 0xBC81, 0x7C40,
    0xB401, 0x74C0, 0x7580, 0xB541, 0x7700, 0xB7C1, 0xB681, 0x7640,
    0x7200, 0xB2C1, 0xB381, 0x7340, 0xB101, 0x71C0, 0x7080, 0xB041,
    0x5000, 0x90C1, 0x9181, 0x5140, 0x9301, 0x53C0, 0x5280, 0x9241,
    0x9601, 0x56C0, 0x5780, 0x9741, 0x5500, 0x95C1, 0x9481, 0x5440,
    0x9C01, 0x5CC0, 0x5D80, 0x9D41, 0x5F00, 0x9FC1, 0x9E81, 0x5E40,
    0x5A00, 0x9AC1, 0x9B81, 0x5B40, 0x9901, 0x59C0, 0x5880, 0x9841,
    0x8801, 0x48C0, 0x4980, 0x8941, 0x4B00, 0x8BC1, 0x8A81, 0x4A40,
    0x4E00, 0x8EC1, 0x8F81, 0x4F40, 0x8D01, 0x4DC0, 0x4C80, 0x8C41,
    0x4400, 0x84C1, 0x8581, 0x4540, 0x8701, 0x47C0, 0x4680, 0x8641,
    0x8201, 0x42C0, 0x4380, 0x8341, 0x4100, 0x81C1, 0x8081, 0x4040
};
//PROVERITI PINOVE
DigitalOut bmsLVWakeUp(PB_0);//PC_9);
DigitalIn bmsFault(PA_4);//PC_8);

Serial pc(PA_0, PA_1, 250000);//PA_9, PA_10,250000);
Serial pc1(USBTX, USBRX, 9600);//PC_10, PC_11,9600);
 
void wakeUp()
{
    bmsLVWakeUp=0;
    wait_us(300);
    bmsLVWakeUp=1;
    wait_ms(12);    
}

uint16_t CRC16(BYTE *pBuf, int nLen)
{
   uint16_t wCRC = 0;
    int i;

    for (i = 0; i < nLen; i++)
    {
        wCRC ^= (*pBuf++) & 0x00FF;
        wCRC = crc16_table[wCRC & 0x00FF] ^ (wCRC >> 8);
    }
    
    return wCRC;
}
void posaljiUARTu(int length, uint8_t * data)
{
    for(int i=0;i<length;i++)
      pc.putc(data[i]);
      wait_ms(1);
}  


int  WriteFrame(BYTE bID, uint16_t& wAddr, BYTE * pData, BYTE bLen, BYTE bWriteType)//pitati Martu!!
{
    
    int    bPktLen = 0;
    BYTE   pFrame[32];
    BYTE * pBuf = pFrame;
    uint16_t   wCRC;

    if (bLen == 7 || bLen > 8)
        return 0;

    memset(pFrame, 0x7F, sizeof(pFrame));
    if (wAddr > 255)    {
        *pBuf++ = 0x88 | bWriteType | bLen; // use 16-bit address
        if (bWriteType == FRMWRT_SGL_R || bWriteType == FRMWRT_SGL_NR )//(bWriteType != FRMWRT_ALL_NR)// || (bWriteType != FRMWRT_ALL_R))
        {
            *pBuf++ = (bID & 0x00FF);
        }
        *pBuf++ = (wAddr & 0xFF00) >> 8;
        *pBuf++ =  wAddr & 0x00FF;
    }
    else {
        
        *pBuf++ = 0x80 | bWriteType | bLen; // use 8-bit address
        if (bWriteType == FRMWRT_SGL_R || bWriteType == FRMWRT_SGL_NR )
        {
            *pBuf++ = (bID & 0x00FF);
        }
        *pBuf++ = wAddr & 0x00FF;
    }
    
    while(bLen--)
        *pBuf++ = *pData++;

    bPktLen = pBuf - pFrame;

    wCRC = CRC16(pFrame, bPktLen);
    *pBuf++ = wCRC & 0x00FF;
    *pBuf++ = (wCRC & 0xFF00) >> 8;
    bPktLen += 2;

    //sciSend(scilinREG, bPktLen, pFrame);

    posaljiUARTu(bPktLen,pFrame);
    
    return bPktLen;
}

int WriteReg(BYTE DevID, uint16_t wAddr, uint64_t dwData, BYTE numDATAb, BYTE bWriteType)// eg: WriteReg(nDev_ID,0x0106,0x01,1, FRMWRT_SGL_NR)
{
    //Kopija Martinog koda
    int bRes = 0;
    BYTE bBuf[8] = {0, 0, 0, 0, 0, 0, 0, 0};
    switch(numDATAb)
    {
    case 1:
        bBuf[0] =  dwData & 0x00000000000000FF;
        
        bRes = WriteFrame(DevID, wAddr, bBuf, 1, bWriteType);
        break;
    case 2:
        bBuf[0] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[1] =  dwData & 0x00000000000000FF;
       
        bRes = WriteFrame(DevID, wAddr, bBuf, 2, bWriteType);
        break;
    case 3:
        bBuf[0] = (dwData & 0x0000000000FF0000) >> 16;
        bBuf[1] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[2] =  dwData & 0x00000000000000FF;
        
        bRes = WriteFrame(DevID, wAddr, bBuf, 3, bWriteType);
        break;
    case 4:
        bBuf[0] = (dwData & 0x00000000FF000000) >> 24;
        bBuf[1] = (dwData & 0x0000000000FF0000) >> 16;
        bBuf[2] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[3] =  dwData & 0x00000000000000FF;
        
        bRes = WriteFrame(DevID, wAddr, bBuf, 4, bWriteType);
        break;
    case 5:
        bBuf[0] = (dwData & 0x000000FF00000000) >> 32;
        bBuf[1] = (dwData & 0x00000000FF000000) >> 24;
        bBuf[2] = (dwData & 0x0000000000FF0000) >> 16;
        bBuf[3] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[4] =  dwData & 0x00000000000000FF;
        
        bRes = WriteFrame(DevID, wAddr, bBuf, 5, bWriteType);
        break;
    case 6:
        bBuf[0] = (dwData & 0x0000FF0000000000) >> 40;
        bBuf[1] = (dwData & 0x000000FF00000000) >> 32;
        bBuf[2] = (dwData & 0x00000000FF000000) >> 24;
        bBuf[3] = (dwData & 0x0000000000FF0000) >> 16;
        bBuf[4] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[5] =  dwData & 0x00000000000000FF;
        
        bRes = WriteFrame(DevID, wAddr, bBuf, 6, bWriteType);
        break;
    case 7:
        bBuf[0] = (dwData & 0x00FF000000000000) >> 48;
        bBuf[1] = (dwData & 0x0000FF0000000000) >> 40;
        bBuf[2] = (dwData & 0x000000FF00000000) >> 32;
        bBuf[3] = (dwData & 0x00000000FF000000) >> 24;
        bBuf[4] = (dwData & 0x0000000000FF0000) >> 16;
        bBuf[5] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[6] =  dwData & 0x00000000000000FF;;
        
        bRes = WriteFrame(DevID, wAddr, bBuf, 7, bWriteType);
        break;
    case 8:
        bBuf[0] = (dwData & 0xFF00000000000000) >> 56;
        bBuf[1] = (dwData & 0x00FF000000000000) >> 48;
        bBuf[2] = (dwData & 0x0000FF0000000000) >> 40;
        bBuf[3] = (dwData & 0x000000FF00000000) >> 32;
        bBuf[4] = (dwData & 0x00000000FF000000) >> 24;
        bBuf[5] = (dwData & 0x0000000000FF0000) >> 16;
        bBuf[6] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[7] =  dwData & 0x00000000000000FF;
        
        bRes = WriteFrame(DevID, wAddr, bBuf, 8, bWriteType);
        break;
    default:
        break;
    }
    return bRes;
}
int  ReadFrameReq(BYTE bID, uint16_t wAddr, BYTE bByteToReturn)
{
    BYTE bReturn = bByteToReturn - 1;

    if (bReturn > 127)
        return 0;

    return WriteFrame(bID, wAddr, &bReturn, 1, FRMWRT_SGL_R);
}
// eg: ReadReg(nDev_ID,0x0207,bFrame,12, 0, FRMWRT_SGL_R)
int ReadReg (BYTE DevID, uint16_t wAddr, void * bufferData, BYTE numDATAb, uint32_t dwTimeOut, BYTE FRM)

{
    //Kopija Martinog koda
    int   bRes = 0;

    switch(numDATAb)
    {
    case 1:
        bRes = ReadFrameReq(DevID, wAddr, 1);
        break;
    case 2:
        bRes = ReadFrameReq(DevID, wAddr, 2);
        break;
    case 3:
        bRes = ReadFrameReq(DevID, wAddr, 3);
        break;
    case 4:
        bRes = ReadFrameReq(DevID, wAddr, 4);
        break;
    default:
        break;
    }
    return bRes;
}

void shutDown()
{
    WriteReg(0,CONTROL1,0x08,1, FRMWRT_ALL_NR);
}

BYTE recBuff[1024];
int recLen=0;
int expected=0;
volatile bool full = false;
int rdLen=0;

void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    //pc1.printf("* * *    Uspesan PRIJEM!     * * *\n");
    while(pc.readable()){
        //pc1.printf("jepse");
        //pc1.printf("%d\n", pc.getc());
        recBuff[recLen++]=pc.getc();
        if(expected==0) expected = recBuff[0]+4;
        if(expected==recLen){
            full=true;
            rdLen=expected;
            expected=0;
            recLen=0;
        }
    }
}
void waitFrame(){
    while(!full);
    full=false;
    for(int i = 0;i<rdLen;i++){
        pc1.printf("%X ",recBuff[i]);
    }
    
    pc1.printf("\n\n- - - VOLTAGE - - -\n");
    for(int i = 1; i < recBuff[0] - 1; i += 2){
               
        int voltage = recBuff[i+1];
        voltage |= (recBuff[i]) << 8;
        double vol = ((double)voltage)/65536.0 * 5.0;
        pc1.printf("CELL[%d] = %.6f V\n",(recBuff[0] - 1)/2 -(i-1)/2,vol);
    }
      
    pc1.printf("\n");
}

int main() 
{
   uint32_t  wTemp = 0;
   pc.attach(&callback);//sta radi callback?
   
   //sciSetBaudrate(scilinREG, 250000);
   pc1.printf("INICIJALIZACIJA START \n");
   wakeUp();
   
   //sciSetBaudrate(scilinREG,250000);
   //CommReset(); 
   WriteReg(0,COMM_CTRL,0x3C3C,2, FRMWRT_ALL_NR);//setting the baud rate to device
   //sciSetBaudrate(scilinREG,1000000);
   
   WriteReg(0,ECC_TEST,0x00,1, FRMWRT_ALL_NR); //dummy write to the ECC_TESTregisterto syncthe DLL
   
   WriteReg(0,CONFIG,0x00,1, FRMWRT_ALL_NR);//making sure auto-address mode is set on all devices(and NOT GPIO address mode)
   
   WriteReg(0,CONTROL1,0x01,1, FRMWRT_ALL_NR);//enabling and entering auto-addressing mode on the devices by setting the CONTROL1 register
   
   WriteReg(0,CONFIG, 0x01 ,1, FRMWRT_SGL_NR);//If there is only one device,you can instead do one command to assign the device as both the base AND top of stack(set CONFIG to 0x01)
   //****
   //ReadReg(0, uint16_t wAddr, void * bufferData, 1, uint32_t dwTimeOut, FRMWRT_SGL_R)//dummy read of ECC_TEST DORADITI!
   //****
   
   WriteReg(0, COMM_TO, 0x56, 1, FRMWRT_ALL_NR);//Setting Communications Timeout (10 minute short communication timeout, sleep mode on long communication timeout, long timeout length of 30 minutes)
   
   WriteReg(0, TX_HOLD_OFF, 0x00, 1, FRMWRT_ALL_NR);//Communications transmit delay set to zero
   
   //masking all low level faults (zakomentovacemo ono sto nam ne treba)
   
   WriteReg(0, 0x0002, 0x3F, 1, FRMWRT_ALL_NR);//GPIO
   WriteReg(0, 0x0003, 0x3F, 1, FRMWRT_ALL_NR);//UV
   WriteReg(0, 0x0004, 0x3F, 1, FRMWRT_ALL_NR);//OV
   WriteReg(0, 0x0005, 0x3F, 1, FRMWRT_ALL_NR);//UT
   WriteReg(0, 0x0006, 0x3F, 1, FRMWRT_ALL_NR);//OT
   WriteReg(0, 0x0007, 0x07, 1, FRMWRT_ALL_NR);//all tone faults
   WriteReg(0, 0x0008, 0x07, 1, FRMWRT_ALL_NR);//UART
   WriteReg(0, 0x0009, 0x3F, 1, FRMWRT_ALL_NR);//UART
   WriteReg(0, 0x000A, 0x3F, 1, FRMWRT_ALL_NR);//UART
   WriteReg(0, 0x000B, 0x03, 1, FRMWRT_ALL_NR);//UART
   WriteReg(0, 0x000C, 0x3F, 1, FRMWRT_ALL_NR);//COMH
   WriteReg(0, 0x000D, 0x3F, 1, FRMWRT_ALL_NR);//COMH
   WriteReg(0, 0x000E, 0x3F, 1, FRMWRT_ALL_NR);//COMH
   WriteReg(0, 0x000F, 0x03, 1, FRMWRT_ALL_NR);//COMH
   WriteReg(0, 0x0010, 0x3F, 1, FRMWRT_ALL_NR);//COML
   WriteReg(0, 0x0011, 0x3F, 1, FRMWRT_ALL_NR);//COML
   WriteReg(0, 0x0012, 0x3F, 1, FRMWRT_ALL_NR);//COML
   WriteReg(0, 0x0013, 0x03, 1, FRMWRT_ALL_NR);//COML
   WriteReg(0, 0x0014, 0x07, 1, FRMWRT_ALL_NR);//OTP
   WriteReg(0, 0x0015, 0xFF, 1, FRMWRT_ALL_NR);//POWER RAIL
   WriteReg(0, 0x0016, 0x7F, 1, FRMWRT_ALL_NR);//SYS_FAULT1
   WriteReg(0, 0x0017, 0xFF, 1, FRMWRT_ALL_NR);//SYS_FAULT2
   WriteReg(0, 0x0018, 0x7F, 1, FRMWRT_ALL_NR);//SYS_FAULT3
   WriteReg(0, 0x0019, 0x03, 1, FRMWRT_ALL_NR);//OVUV BIST
   WriteReg(0, 0x001A, 0xFF, 1, FRMWRT_ALL_NR);//OTUT BIST
   
   //MASKING_END
   
   pc1.printf("INICIJALIZACIJA END \n");
   
   pc1.printf("Response? \n");
   // read device ID to see if there is a response
   ReadReg(0, 10, &wTemp, 1, 0,FRMWRT_SGL_R );
   wait_ms(10);
   wait(1);
   
   WriteReg(0, CONTROL2, 0x00, 1, FRMWRT_ALL_NR);//Set OVUV_EN=0 before changing settings
   
   WriteReg(0, 0x29, 0x3F, 1, FRMWRT_ALL_NR);//enabling over voltage under voltage for all 6? cell channels
   WriteReg(0, 0x2A, 0x53, 1, FRMWRT_ALL_NR);//set cell UV to 2.8 V
   WriteReg(0, 0x2B, 0x5B, 1, FRMWRT_ALL_NR);// set cell OV to 4.3V
   
   WriteReg(0, CONTROL2, 0x04, 1, FRMWRT_ALL_NR);//OVUV_EN=1
   
   WriteReg(0, 0x28, 0x3F, 1, FRMWRT_ALL_NR);//configure GPIO as AUX voltage(absolute voltage INSTEAD OF RATIOMETRIC) if necessary
   
   WriteReg(0, 0x27, 0x00, 1, FRMWRT_SGL_NR);//modifying the ADC delay of each device individually, since there is only one...modify device 0 delay
   
   WriteReg(0, 0x26, 0x08, 1, FRMWRT_ALL_NR);//AUX sample rate 1 MHz,128 decimation ratio
   WriteReg(0, 0x24, 0x23, 1, FRMWRT_ALL_NR);//1 MHz sample rate,64 decimation ratio,19.7Hz LPF
   WriteReg(0, 0x25, 0x02, 1, FRMWRT_ALL_NR);//5 ms conversion interval if continuous conversion enabled
   
   /*
   nSent= WriteReg(0,CONTROL2,0x10,1, FRMWRT_ALL_NR);// enable TSREF-external temperature sensors
   delayms(2);// provides settling time for TSREF
   */
   
   WriteReg(0, 0x109, 0x3F, 1, FRMWRT_ALL_NR);// enables ADC for all 6 cell channels
   wait_ms(5);// ensure proper settling time for best accuracy
   
   
   //WHICHEVER WE NEED
   //One-Shot ADC Conversions
   WriteReg(0, CONTROL2, 0x01, 1, FRMWRT_ALL_NR);//set the CELL_ADC_GO bit
   wait_ms(5);//delay for ADC accuracy
   
   //DORADI!
   //ReadReg(0, 0x215, void * bufferData, 12, 0, FRMWRT_SGL_R);// will return 6 overhead byte sand 12 data bytes per device, highest device address responds first
   wait_ms(1);
   
   //Continuous ADC Conversions
   WriteReg(0, 0x25, 0x0A, 1, FRMWRT_ALL_NR);// enable continuous conversion with 5ms conversion interval
   WriteReg(0, CONTROL2, 0x01, 1, FRMWRT_ALL_NR);//set the CELL_ADC_GO bit
   wait_ms(5);//delay for ADC accuracy
   //da li je ovo ispod isto sto i Martin waitFrame? Ako jeste staviti ga u posebnu funkciju, ako nije proveriti da li je uopste potrebno
   //ReadReg(0, 0x215, void * bufferData, 12, 0, FRMWRT_SGL_R);// will return 6 overhead byte sand 12 data bytes per device, highest device address responds first
   wait_ms(1);//ISTA STVAR KAO IZNAD KOD ONE-SHOT
   //martin deo koda
   while (1) {
        pc1.printf("Main Code \n");
        wait(2);
        //*****
        WriteReg(0, 2, 0x20, 1, FRMWRT_SGL_R); // send read sampled values command, OVO TREBA PROMENITI AKO VEC ZADRZAVAS OVAJ KOD!!!!!
        //*****
        waitFrame();
        if(bmsFault)
            pc1.printf("- - - GRESKA FAULT! - - -\n");
    

    }
   
   
}
