/* Copyright (c) 2014 J Kernthaler MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef K64MAGACC_H
#define K64MAGACC_H
#include "mbed.h"

const PinName SDA = PTE25;
const PinName SDL = PTE24;
const int FX_addr = (0x1D<<1);

class K64MagAcc
{
/** K64MagAcc class
 *  Used for setting up and reading data from the FXOS8700Q device on the
 *  K64F board.
 *  Usage
 *      Call the Update method to read data from the device
 *      The data is made available through two float arrays Mag and Acc
 */
public:
    /**
    *   K64MagAcc constructor
    *
    *  @param sda Pin name of the I2C sda connection
    *  @param sdl Pin name of the sdl connection
    *  @param addr Address of the device on the I2C bus
    *  @note On the K64F board these parameters are hard wired, so you can leave them out to use the default settings
    */
    K64MagAcc(PinName sda = SDA, PinName sdl = SDL, int addr = FX_addr);
    void Update(void);
    uint8_t WhoAmI();
    int16_t MagData[3], AccData[3]; // raw data picked from data read
    float Mag[3], Acc[3]; // scaled values in micro-Tesla and g
    uint8_t Status;
    
private:
    void readRegs(int addr, uint8_t * data, int len) ;
    void writeRegs(uint8_t * data, int len);
    int16_t Unpick14(int);
    int16_t Unpick(int);
    void Scale(int16_t*, float*, float);
    void writeControl(uint8_t reg, uint8_t data);
    I2C i2c;
    int i2addr; 
    uint8_t SensorData[13];
};

#endif
