#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mbed.h"

#define PI        (3.141592653589793238462)
#define AMPLITUDE (1.0)    // x * 3.3V
#define PHASE     (PI * 1) // 2*pi is one period
#define RANGE     (0x7FFF)
#define OFFSET    (0x7FFF)

// Configuration for sinewave output
#define BUFFER_SIZE (120)
uint16_t buffer[BUFFER_SIZE];

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalIn button(PC_13);
AnalogOut Vout(PA_4);

// Create the sinewave buffer
void calculate_sinewave(void){
  for (int i = 0; i < BUFFER_SIZE; i++) {
     double rads = (PI * (i*3))/180.0; // Convert degree in radian
     buffer[i] = (uint16_t)(AMPLITUDE * (RANGE * (cos(rads + PHASE))) + OFFSET);
  }
}


void sinecom(char* inputstring) {
    
    calculate_sinewave();
    char s[20];
    char sV[20];
    char sF[20];
    int pos, len;
    int i = 1;
    strcpy(s, inputstring);
    len = strlen(s);
    
    
    for (; i < len; i++){     
            if (s[i] == ' '){
                pos = i;
                break;
                }
        }
        
    memcpy(sF, &s[pos], len-pos);          
    memcpy(sV, &s[0], pos);
    float inV = atof(sV);
    float input_f = atof(sF);
    pc.printf("Voltage: %f \n\r",inV);
    pc.printf("Frequency: %f \n\r",input_f);

    float wait_time = -9.955923 + (20817940 + 9.955923) / (1 + powf(input_f/0.0007111212, 1.049561));  //took data points and got this equation by estimating the graph with computer, results in 1-3% error
    
    while(!pc.readable()) {      
        // sinewave output
        for (int i = 0; i < BUFFER_SIZE; i++) {
            Vout.write_u16(buffer[i]/(3.30 * (1.00/inV)));
            wait_us((int)wait_time);
        }
    }
    return;
}

void ledcom(char* onoff)
{
    if(strstr(onoff, "ON") != NULL)
        led1 = 1; 
    else 
        led1 = 0;
}

void buttoncom(void)
{
    if(button.read() == 0){
        pc.printf("PRESSED \n\r");
        }
    else if (button.read() != 0) {
        pc.printf("RELEASED \n\r");
        }
}

void blinkcom(char* reps)
{
    int x = atoi(reps);
    int i;
    for(i = 0; i < x; i++)
    {
        led1 = 1;
        wait(.5);
        led1 = 0;
        wait(.5);
    }
}

void dccom(char *volts)
{
    float volt = atof(volts);
    pc.printf("voltage output: %4.2f \n\r", volt);
    Vout.write_u16((volt/3.317)*0xFFFF); 
}


int main() {
    char s[20];
    pc.printf("Enter command \n\r");
    while (true) {
        int j = 0;
        char c;
    
        while(true){
            c = pc.getc();
            pc.putc(c);
            s[j]=c;
            j++;
            if(c == '\r'){
                pc.printf("\n\r");
                break;
                }
            }
        s[j] = '\0'; 
        char s_one[20];
        char s_two[20];
        int len = strlen(s);
        int pos = 0;
        
        int i = 0;
        for (; i < len; i++){
            
            if (s[i] == ' '){
                pos = i;
                break;
                }
            else if (i == len)
                pos = len+1;
        }
        
        
        if (pos <= len){
            memcpy(s_two, &s[pos], len-pos);
            s_two[len - pos] = '\0';
            
            memcpy(s_one, &s[0], pos+1);
            s_one[pos] = '\0';
            }
        
        else {
            memcpy(s_one, &s[0], len);
            s_one[len] = '\0';
            pc.printf("%s \n\r", s_one);
            }//case where there is no space  


        if (strstr(s_one, "LED") != NULL) {
            ledcom(s_two);
            }
        else if (strstr(s, "BUTTON") != NULL) {
            buttoncom();
            }
        else if (strstr(s_one, "BLINK") != NULL) {
            blinkcom(s_two);
            }
        else if (strstr(s_one, "DC") != NULL) {
            dccom(s_two);
            }
        else if (strstr(s_one, "SINE") != NULL){
            sinecom(s_two);
            }
        else pc.printf("Bad command, try again buddy \n\r");         
        }
}