#include "mbed.h"
#include "stdio.h"
#include "string.h"
#include "TextLCD.h"

DigitalOut rojo(LED1);  // R
DigitalOut verde(LED2); // G
DigitalOut azul(LED3);  // B
 
Serial usart(PTA2,PTA1);  //puertos del FRDM para el modem
Serial pc(USBTX,USBRX);

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

Timer tiempo;           // Variable para contar

int selector;
 
char buffer[4];

int readBuffer(char *buffer,int count);
void cleanBuffer(char *buffer, int count);
int reconocerColor(char *buffer);

//esta funcion lee un bufer de datos
int readBuffer(char *buffer,int count){
    
    int i=0; 
    tiempo.start();    //CUENTA EL TIEMPO DE CONEXION E INICIA
    while(1) {
        while (usart.readable()) {
            char c = usart.getc();
            if (c == '\r' || c == '\n') c = '%';//si se envia fin de linea o de caracxter inserta $
            buffer[i++] = c;//mete al bufer el caracter leido
            if(i > count)break;//sale del loop si ya detecto terminacion
        }
        if(i > count)break;
        if(tiempo.read() > 0.5) {  //MAS DE UN SEGUNDO DE ESPERA SE SALE Y REINICA EL RELOJ Y SE SALE
            tiempo.stop();
            tiempo.reset();
            break;
        }
    }
     return 0;
}
 
//esta funcion limpia el bufer
void cleanBuffer(char *buffer, int count){
    
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
    
}

int reconocerColor (char *buffer){

    int opcion;
    switch(buffer[0]){
        case 'R': opcion = 1; break;
        case 'G': opcion = 2; break;
        case 'B': opcion = 3; break;
        case 'A': opcion = 4; break;
        default : opcion = 0; break;
    }
    return opcion;    

}
 
int main() {
    
    usart.baud(9600);
    usart.format(8,Serial::None,1);    
    rojo = 1;
    verde = 1;
    azul = 1;
    
    while(1){
        
        while (usart.readable()){
            
            readBuffer(buffer, 7);
            pc.printf("buffer= %s \n\r ",buffer);
            selector = reconocerColor(buffer);
            pc.printf("opcion= %u \n\r ",selector);        
            switch(selector){
                case 1: 
                    rojo = 0; verde = 1; azul =1;
                    lcd.cls();
                    lcd.printf("ROJO\n"); 
                    break;
                case 2: 
                    rojo = 1; verde = 0; azul =1;
                    lcd.cls();
                    lcd.printf("VERDE\n"); 
                    break;
                case 3: 
                    rojo = 1; verde = 1; azul =0;
                    lcd.cls();
                    lcd.printf("AZUL\n");
                    break;
                case 4: 
                    rojo = 0; verde = 0; azul =0; 
                    lcd.cls();
                    lcd.printf("BLANCO\n");
                    break;
                default: break;                                                                        
            }
             
        }
        
    }
    
}

    