#include "mbed.h"
#include "stdio.h"
#include "string.h"

PwmOut rojo(LED1);  // R
PwmOut verde(LED2); // G
PwmOut azul(LED3);  // B
 
Serial usart(PTA2,PTA1);  //puertos del FRDM para el modem
Serial pc(USBTX,USBRX);

Timer tiempo;           // Variable para contar

int selector;
int valor_Rojo;
int valor_Verde;
int valor_Azul;
float pwm_Rojo = 1.0f;
float pwm_Verde = 1.0f;
float pwm_Azul = 1.0f;
 
char buffer[8];

int readBuffer(char *buffer,int count);
void cleanBuffer(char *buffer, int count);
int reconocerColor(char *buffer);
int tomarValor (char *buffer);

//esta funcion lee un bufer de datos
int readBuffer(char *buffer,int count){
    
    int i=0; 
    tiempo.start();    //CUENTA EL TIEMPO DE CONEXION E INICIA
    while(1) {
        while (usart.readable()) {
            char c = usart.getc();
            if (c == '\r' || c == '\n') c = '%';//si se envia fin de linea o de caracxter inserta $
            buffer[i++] = c;//mete al bufer el caracter leido
            if(i > count)break;//sale del loop si ya detecto terminacion
        }
        if(i > count)break;
        if(tiempo.read() > 0.5) {  //MAS DE UN SEGUNDO DE ESPERA SE SALE Y REINICA EL RELOJ Y SE SALE
            tiempo.stop();
            tiempo.reset();
            break;
        }
    }
     return 0;
}
 
//esta funcion limpia el bufer
void cleanBuffer(char *buffer, int count){
    
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
    
}

int reconocerColor (char *buffer){

    int opcion;
    switch(buffer[0]){
        case 'R': opcion = 1; break;
        case 'G': opcion = 2; break;
        case 'B': opcion = 3; break;
        default : opcion = 0; break;
    }
    return opcion;    

}

int tomarValor (char *buffer){
 
    int valor;
    int paro = 0;
    int unidades;
    int decenas;
    int centenas;
    
    if (buffer[1] == '\r' || buffer[1] == '\n' || buffer[1]-47 < 1 || buffer[1]-48 > 9){
        valor = 0;
        paro = 1;
    } else {
        unidades = buffer[1]-48;
    }
    
    if (buffer[2] == '\r' || buffer[2] == '\n' || buffer[2]-47 < 1 || buffer[2]-48 > 9){
        valor = unidades;
    } else if (paro == 0) {
        decenas = unidades;
        unidades = buffer[2]-48;
    }
    
    if (buffer[3] == '\r' || buffer[3] == '\n' || buffer[3]-47 < 1 || buffer[3]-48 > 9){
        valor = decenas*10 + unidades;     
    } else if (paro == 0){
        centenas = decenas;
        decenas = unidades;
        unidades = buffer[3]-48;
        valor = centenas*100 + decenas*10 + unidades;
    }
    
    return valor;     
     
}
 
int main() {
    
    usart.baud(9600);
    usart.format(8,Serial::None,1); 
    
    rojo.period(0.02f);  // 4 second period
    verde.period(0.02f);  // 4 second period
    azul.period(0.02f);  // 4 second period
    
    rojo.write(pwm_Rojo);  // 0% duty cycle
    verde.write(pwm_Verde);  // 0% duty cycle
    azul.write(pwm_Azul);  // 0% duty cycle    
    
    while(1){
        
        while (usart.readable()){
            
            readBuffer(buffer, 7);
            pc.printf("buffer= %s \n\r ",buffer);
            selector = reconocerColor(buffer);
            pc.printf("opcion= %u \n\r ",selector);        
            switch(selector){
                case 1:
                    valor_Rojo = tomarValor(buffer);
                    pwm_Rojo = (float)valor_Rojo / 999.0f;
                    pwm_Rojo = 1.0f - pwm_Rojo;
                    pc.printf("pwm_Rojo= %u \n\r ",pwm_Rojo);
                    rojo.write(pwm_Rojo); 
                    break;
                case 2:
                    valor_Verde = tomarValor(buffer);
                    pwm_Verde = (float)valor_Verde / 999.0f;
                    pc.printf("pwm_Verde= %u \n\r ",pwm_Verde);
                    pwm_Verde = 1.0f - pwm_Verde;
                    verde.write(pwm_Verde); 
                    break;
                case 3:
                    valor_Azul = tomarValor(buffer);
                    pwm_Azul = (float)valor_Azul / 999.0f;
                    pc.printf("pwm_Azul= %u \n\r ",pwm_Azul);
                    pwm_Azul = 1.0f - pwm_Azul;
                    azul.write(pwm_Azul); 
                    break;
                default:
                    break;                                                                        
            }
             
        }
        
    }
    
}

    