#include "mbed.h"
#include "MAX14720.h"
#include "MAX30102.h"
#include "USBSerial.h"
#include "System.h"
#include "algorithm.h"

/// define the HVOUT Boost Voltage default for the MAX14720 PMIC
#define HVOUT_VOLTAGE 4500 // set to 4500 mV

#define MAX14720_I2C_SLAVE_ADDR (0x54)

#define MAX_BRIGHTNESS 255

uint32_t aun_ir_buffer[500]; //IR LED sensor data
int32_t n_ir_buffer_length;    //data length
uint32_t aun_red_buffer[500];    //Red LED sensor data
int32_t n_sp02; //SPO2 value
int8_t ch_spo2_valid;   //indicator to show if the SP02 calculation is valid
int32_t n_heart_rate;   //heart rate value
int8_t  ch_hr_valid;    //indicator to show if the heart rate calculation is valid
uint8_t uch_dummy;

//Serial pc(USBTX, USBRX);    //initializes the serial port
/// Define with Maxim VID and a Maxim assigned PID, set to version 0x0001 and non-blocking

USBSerial usbSerial(0x0b6a, 0x0122, 0x0001, false);

/// I2C Master 2
I2C i2c2(I2C2_SDA, I2C2_SCL); // used by MAX14720, MAX30101, LIS2DH
/// SPI Master 0 with SPI0_SS for use with MAX30001

MAX14720 max14720(&i2c2, MAX14720_I2C_SLAVE_ADDR);
DigitalOut led(LED1); 
DigitalIn INT(P4_0);
int main(){
//---------------------------------------------------
  // hold results for returning functions
    int result;
    // initialize HVOUT on the MAX14720 PMIC
    result = max14720.init();
    if (result == MAX14720_ERROR){
        printf("Error initializing MAX14720");
    }
    max14720.boostEn = MAX14720::BOOST_ENABLED;
    max14720.boostSetVoltage(HVOUT_VOLTAGE);
//--------------------------------------------------- 
    uint32_t un_min, un_max, un_prev_data;  //variables to calculate the on-board LED brightness that reflects the heartbeats
    int i;
    int32_t n_brightness;
    float f_temp;
    long unBlockedValue = 0;
    
    maxim_max30102_reset(); //resets the MAX30102
    wait(1);
    maxim_max30102_init();  //initializes the MAX30102
        
    n_brightness=0;
    un_min=0x3FFFF;
    un_max=0;
  
    n_ir_buffer_length=500; //buffer length of 100 stores 5 seconds of samples running at 100sps
    
    //read the first 500 samples, and determine the signal range
    for(i=0;i<n_ir_buffer_length;i++)
    {
        while(INT.read()==1);   //wait until the interrupt pin asserts
        
        maxim_max30102_read_fifo((aun_red_buffer+i), (aun_ir_buffer+i));  //read from MAX30102 FIFO
            
        if(un_min>aun_red_buffer[i])
            un_min=aun_red_buffer[i];    //update signal min
        if(un_max<aun_red_buffer[i])
            un_max=aun_red_buffer[i];    //update signal max
        /*usbSerial.printf("red=");
        usbSerial.printf("%i", aun_red_buffer[i]);
        usbSerial.printf(", ir=");
        usbSerial.printf("%i\n\r", aun_ir_buffer[i]);*/
    }
    un_prev_data=aun_red_buffer[i];
    
    
    //calculate heart rate and SpO2 after first 500 samples (first 5 seconds of samples)
    maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer, n_ir_buffer_length, aun_red_buffer, &n_sp02, &ch_spo2_valid, &n_heart_rate, &ch_hr_valid); 
    
    //Continuously taking samples from MAX30102.  Heart rate and SpO2 are calculated every 1 second
  
  
  while (1) {
        i=0;
        un_min=0x3FFFF;
        un_max=0;
        
        //dumping the first 100 sets of samples in the memory and shift the last 400 sets of samples to the top
        for(i=200;i<500;i++)
        {
            aun_red_buffer[i-200]=aun_red_buffer[i];
            aun_ir_buffer[i-200]=aun_ir_buffer[i];
            
            //update the signal min and max
            if(un_min>aun_red_buffer[i])
            un_min=aun_red_buffer[i];
            if(un_max<aun_red_buffer[i])
            un_max=aun_red_buffer[i];
        }
        
        //take 100 sets of samples before calculating the heart rate.
        for(i=300;i<500;i++)
        {
            un_prev_data=aun_red_buffer[i-1];
            while(INT.read()==1);
            maxim_max30102_read_fifo((aun_red_buffer+i), (aun_ir_buffer+i));
        
            if(aun_red_buffer[i]>un_prev_data)
            {
                f_temp=aun_red_buffer[i]-un_prev_data;
                f_temp/=(un_max-un_min);
                f_temp*=MAX_BRIGHTNESS;
                n_brightness-=(int)f_temp;
                if(n_brightness<0)
                    n_brightness=0;
            }
            else
            {
                f_temp=un_prev_data-aun_red_buffer[i];
                f_temp/=(un_max-un_min);
                f_temp*=MAX_BRIGHTNESS;
                n_brightness+=(int)f_temp;
                if(n_brightness>MAX_BRIGHTNESS)
                    n_brightness=MAX_BRIGHTNESS;
            }
            //send samples and calculation result to terminal program through UART
            /*usbSerial.printf("red=");
            usbSerial.printf("%i", aun_red_buffer[i]);
            usbSerial.printf(", ir=");
            usbSerial.printf("%i", aun_ir_buffer[i]);*/
            usbSerial.printf("HR=%i\t", n_heart_rate); 
            //usbSerial.printf("HRvalid=%i, ", ch_hr_valid);
            usbSerial.printf("SpO2=%i\n\r", n_sp02);
            //usbSerial.printf("SPO2Valid=%i\n\r", ch_spo2_valid);
        }
        maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer, n_ir_buffer_length, aun_red_buffer, &n_sp02, &ch_spo2_valid, &n_heart_rate, &ch_hr_valid); 
  } 
}