 #include "mbed.h"
 #include "MAX14720.h"
 #include "MAX30001.h"
 #include "MAX30101.h"
 #include "System.h"
 #include "USBSerial.h"

 /************************************************************************************************************************************/
 /// define the HVOUT Boost Voltage default for the MAX14720 PMIC
 #define HVOUT_VOLTAGE 4500 // set to 4500 mV
 
 /// define all I2C addresses
 #define MAX14720_I2C_SLAVE_ADDR (0x54)
 #define MAX30101_I2C_SLAVE_ADDR (0xAE)
 
 // Settings for ECG Initialization
 #define En_ecg     0x01
 #define Openp      0x00
 #define Openn      0x00
 #define Pol        0x00
 #define Calp_sel   0x00
 #define Caln_sel   0x00
 #define E_fit      0x0F
 #define Rate       0x02
 #define Gain       0x00
 #define Dhpf       0x01
 #define Dlpf       0x01
 
 // Settings for ECG RtoR
 #define En_rtor    0x01
 #define Wndw       0x03
 #define Gain1      0x0f
 #define Pavg       0x02
 #define Ptsf       0x03
 #define Hoff       0x20
 #define Ravg       0x02
 #define Rhsf       0x04
 #define Clr_rrint  0x01
 
 // Settings for Lead Detection
 #define En_dcloff  0x01
 #define Ipol       0x00
 #define Imag       0x01
 #define Vth        0x00
 
 // Settings for the HR initialization
 #define FIFO_WATERLEVEL_MARK 15
 #define SAMPLE_AVG           2
 #define SAMPLE_RATE          1
 #define PULSE_WIDTH          2
 #define RED_LED_CURRENT      0x1F
 #define IR_LED_CURRENT       0X1F
 
 /// Define with Maxim VID and a Maxim assigned PID, set to version 0x0001 and non-blocking
 USBSerial usbSerial(0x0b6a, 0x0100, 0x0001, false);
 
 // I2C Master 2
 I2C i2c2(I2C2_SDA, I2C2_SCL); // used by MAX14720, MAX30101, LIS2DH
 
 // SPI Master 0 with SPI0_SS for use with MAX30001
 SPI spi(SPI0_MOSI, SPI0_MISO, SPI0_SCK, SPI0_SS); // used by MAX30001
 
 // PMIC
 MAX14720 max14720(&i2c2, MAX14720_I2C_SLAVE_ADDR);
 
 // Optical Oximeter
 //MAX30101 max30101(&i2c2, MAX30101_I2C_SLAVE_ADDR);
 //InterruptIn max30101_Interrupt(P4_0);

 // ECG device
 MAX30001 max30001(&spi);
 InterruptIn max30001_InterruptB(P3_6);
 InterruptIn max30001_Interrupt2B(P4_5);
 
 /// PWM used as fclk for the MAX30001
 PwmOut pwmout(P1_7);
  
 // Data of sensors
 int32_t ECG_Raw, RtoR_data;
 uint32_t index = 0;
 
 //int32_t SpO_Raw;
 DigitalOut led(LED1); 
 
 //@brief Creates a packet that will be streamed via USB Serial
 //@brief the packet created will be inserted into a fifo to be streamed at a later time
 //@param id Streaming ID
 //@param buffer Pointer to a uint32 array that contains the data to include in the packet
 //@param number Number of elements in the buffer
 //
 void StreamPacketUint32_ex(uint32_t id, uint32_t *buffer, uint32_t number) {
    if(id == MAX30001_DATA_ECG)
    {
        for (int k = 0; k < number; k++) 
        {
            ECG_Raw = (int32_t)(buffer[k] << 8);
            ECG_Raw = ECG_Raw >> 14;
            usbSerial.printf("%d|" , index);
            usbSerial.printf("%d\r\n", ECG_Raw);
            index++;
        }
    }
    /*if(id == MAX30001_DATA_RTOR)
    {
           for(int i = 0; i < number; i++)
           {
               RtoR_data = (buffer[i]);
               //usbSerial.printf("HR: %d\r\n", (60000/(RtoR_data << 3)));
           }     
    }*/
    if(id == MAX30001_DATA_LEADOFF_DC)
    {
        usbSerial.printf("LOFF\r\n");
    }
 }
 int main() {
    // hold results for returning functions
    int result;
    
    // initialize HVOUT on the MAX14720 PMIC
    result = max14720.init();
    if (result == MAX14720_ERROR){
        printf("Error initializing MAX14720");
    }
    max14720.boostEn = MAX14720::BOOST_ENABLED;
    max14720.boostSetVoltage(HVOUT_VOLTAGE);
    
    // Interrupt priority    
    NVIC_SetPriority(GPIO_P0_IRQn, 5);
    NVIC_SetPriority(GPIO_P1_IRQn, 5);
    NVIC_SetPriority(GPIO_P2_IRQn, 5);
    NVIC_SetPriority(GPIO_P3_IRQn, 5);
    NVIC_SetPriority(GPIO_P4_IRQn, 5);
    NVIC_SetPriority(GPIO_P5_IRQn, 5);
    NVIC_SetPriority(GPIO_P6_IRQn, 5);
    // used by the MAX30001
    NVIC_SetPriority(SPI1_IRQn, 0);
    
    /* ECG Initialize */
    max30001_InterruptB.disable_irq();
    max30001_Interrupt2B.disable_irq();
    max30001_InterruptB.mode(PullUp);
    max30001_InterruptB.fall(&MAX30001Mid_IntB_Handler);
    max30001_Interrupt2B.mode(PullUp);
    max30001_Interrupt2B.fall(&MAX30001Mid_Int2B_Handler);
    max30001_InterruptB.enable_irq();
    max30001_Interrupt2B.enable_irq();
    MAX30001_AllowInterrupts(1);    
    // Configuring the FCLK for the ECG, set to 32.768KHZ
    pwmout.period_us(31);
    pwmout.write(0.5);          // 0-1 is 0-100%, 0.5 = 50% duty cycle.
    max30001.max30001_sw_rst(); // Do a software reset of the MAX30001
    max30001.max30001_INT_assignment(
        MAX30001::MAX30001_INT_B,  // en_enint_loc
        MAX30001::MAX30001_NO_INT, // en_eovf_loc
        MAX30001::MAX30001_NO_INT, // en_fstint_loc

        MAX30001::MAX30001_INT_2B, // en_dcloffint_loc
        MAX30001::MAX30001_INT_B, // en_bint_loc
        MAX30001::MAX30001_NO_INT, // en_bovf_loc

        MAX30001::MAX30001_INT_2B, // en_bover_loc
        MAX30001::MAX30001_INT_2B, // en_bundr_loc
        MAX30001::MAX30001_NO_INT, // en_bcgmon_loc

        MAX30001::MAX30001_INT_B,  // en_pint_loc
        MAX30001::MAX30001_NO_INT, // en_povf_loc,
        MAX30001::MAX30001_NO_INT, // en_pedge_loc

        MAX30001::MAX30001_INT_2B, // en_lonint_loc
        MAX30001::MAX30001_INT_B,  // en_rrint_loc
        MAX30001::MAX30001_NO_INT, //  en_samp_loc

        MAX30001::MAX30001_INT_ODNR,  // intb_Type
        MAX30001::MAX30001_INT_ODNR); // int2b_Type
        
    // MAX30001 initialize interrupt
    max30001.max30001_ECG_InitStart(En_ecg, Openp, Openn, Pol, Calp_sel, Caln_sel, E_fit, Rate, Gain, Dhpf, Dlpf);
    //max30001.max30001_RtoR_InitStart(En_rtor, Wndw, Gain1, Pavg, Ptsf, Hoff, Ravg, Rhsf, Clr_rrint);
    max30001.max30001_Enable_DcLeadOFF_Init(En_dcloff, Ipol, Imag, Vth);
    //max30001.max30001_FIFO_LeadONOff_Read();
    max30001.max30001_synch();
    max30001.onDataAvailable(&StreamPacketUint32_ex);
    int a;
    while (1) 
    {
        
        a = usbSerial._getc();
        if (a == 65)
        {
            max30001.max30001_Stop_ECG();
            max30001.max30001_Disable_DcLeadOFF();
            index = 0;
        }
        if (a == 97)
        {
            //max30001.max30001_sw_rst(); 
            max30001.max30001_ECG_InitStart(En_ecg, Openp, Openn, Pol, Calp_sel, Caln_sel, E_fit, Rate, Gain, Dhpf, Dlpf);
            max30001.max30001_Enable_DcLeadOFF_Init(En_dcloff, Ipol, Imag, Vth);
            //max30001.max30001_synch();
            //max30001.onDataAvailable(&StreamPacketUint32_ex);            
        }
    }
}

