#include "mbed.h"
#include "SensorHandler.h"
#include <dbg.h>
#include "DHT22.h"
#include "Leitura.h"
#include "Atuadores.h"
#define DELIMITER   ("&")

extern bool g_bLed1;
int estado;
extern int EstadoCarr;
extern int EstadoAr;


SensorHandler::SensorHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket) : HTTPRequestHandler(rootPath, path, pTCPSocket)

{
    DBG("SensorHandler()\r\n");
}

SensorHandler::~SensorHandler()
{
    DBG("~SensorHandler()\r\n");
}
void SensorHandler::printString( const char* pszString )
{
    writeData( pszString, strlen(pszString) );
}

void SensorHandler::printHtml()
{
    respHeaders()["Connection"] = "close";

    printString( "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n" );
    printString( "<html lang=\"ja\">\n" );
    printString( "<head>\n" );
    printString( "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n" );
    printString( "<meta http-equiv=\"Content-Style-Type\" content=\"text/css\">\n" );
    printString( "<title>Sistema de Monitoramento</title><br />\n" );
    printString( "</head>\n" );
    printString( "<body>\n" );
    //printString("<img src=logo.png alt=Logo style=position:absolute;top:50px;right:10px; />");
    printString("<center><img src=\"http://www.cbm.sc.gov.br/templates/kodadesign/images/topo_site_88anos.jpg\"></ center>");
    printString( "<p style=font-size:40px;font-family:courier><b> Sistema de Monitoramento de Estaçãoes Repetidoras<b></p>");
    
    printString("<table width=\"100%\">");
    printString("<tr>");
    printString( "<td>Temperatura: " );
    sprintf( szTemp2, "%4.1d", szTemp);
    printString(szTemp2);
    printString("°C");
    printString("</td>");
    printString("<td>Corrente ACS01:");
    printString(Corrente);
    printString("A </td>");
    printString("<td>Tensão do Banco de Baterias:");
    printString(TensCC);
    printString("V</td>");
    printString("</tr><tr>");
    printString("<td>Umidade:");
    sprintf( szUmid2, "%4.1d", szUmid);
    printString(szUmid2);
    printString("%</td>");
    printString("<td>Corrente ACS02:");
    printString(Corrente2);
    printString("A</td>");
    printString("<td>Ar Condicionado:");
    if (EstadoAr == 1){printString("Ligado");}
    if (EstadoAr == 0){printString("Desligado");}
    printString("</td><tr>");
    if (AC == 1) {printString("<td><label>Rede Elétrica:"); printString("<FONT COLOR=\" blue\"> Rede Eletrica Ligada</FONT><label></td>");}
    if (AC == 0) {printString("<td><label>Rede Elétrica:"); printString("<FONT COLOR=\" red\"> Falha na Alimentação</FONT><label></td>");}
    printString("<td>Corrente ACS03:");
    printString(Corrente3);
    printString("A</td>");
    printString("<td>Carregador:");
    if (EstadoCarr == 1){printString("Ligado");}
    if (EstadoCarr == 0){printString("Desligado");}
    printString("</td></tr>");
    printString("<br><hr>\n");
     
    
    printString("</table><br><br>");
    
    printString("<form method=\"post\" action=\"\">\n");
    printString("<table width=\"100%\">");
    printString("<tr>");
    printString("<td><label><input type=\"radio\" name=\"led1\" value=\"1\""); if(g_bLed1 == false){ printString(" checked"); } printString(">Lampadas Desligadas</label><br></td>\n");
    printString("<td rowspan=\"3\"><a href=\"http://10.193.240.157/main.cgi?next_file=video2.htm\" target=\"_blank\"><img src=\"http://10.193.240.157/img/video.mjpeg\" width=\"'342' height= '23'\"></a></td>");
    printString("</tr><tr>");
    printString("<td><label><input type=\"radio\" name=\"led2\" value=\"1\""); if(g_bLed1 == true){ printString(" checked"); } printString(">Lampadas Ligadas</label><br></td>\n");
    printString("</tr><tr>");
    if(g_bLed1 == false){ printString("<td><input type=\"submit\"style=\"font-weight:30px; color: blue\" value=\"Ligar Lampadas\" style=\"width: 200px; height: 80px\"></td>\n");}
    if(g_bLed1 == true){ printString("<td><input type=\"submit\" style=\"font-weight:30px; color: red\" value=\"Desl. Lampadas\"style=\"width: 200px; height: 80px\"></td>\n");}
    printString("</tr></table><br><br>");  
    printString("</form>\n");
    printString("</body>\n");
    printString("</html>");
}
void SensorHandler::doGet()
{
    DBG("doGet()\n");
    printHtml();
 }
// botoes acionadores copia: https://developer.mbed.org/users/star297/code/ESP8266-WEB-Mbed-Controller/file/f7febfa77784/main.cpp
// https://developer.mbed.org/users/star297/code/ESP8266-WEB-Mbed-Controller/
static void analyzePostData( char* pszLine, bool& rbLed1)
{
    rbLed1 = false;
     char* pszToken = strtok(pszLine, DELIMITER);
    while(pszToken)
    {
        if( 6 == strlen(pszToken)
         && 0 == strncmp(pszToken, "led", 3) )
        {   // led?=1
            if(      '1' == pszToken[3] ){ rbLed1 = true; }
            else if( '2' == pszToken[3] ){ rbLed1 = false; }
             }
          //   else{ rbLed1 = false;}
             //else if  (    '1' != pszToken[3] ){ rbLed1 = false; }
             
        pszToken = strtok(NULL, DELIMITER);
    }
}
void SensorHandler::doPost()
{
    DBG("doPost()\r\n");
    int iCountData = dataLen(); //add posterior
    if( 0 == iCountData )
    { 
    printHtml();       
    return; 
    }
  char* pszData = (char*) malloc( sizeof(char) * (iCountData + 1) );
  readData( pszData, iCountData );
  pszData[iCountData] = '\0';
    
    DBG( pszData );
    
    bool bLed1;
    analyzePostData( pszData, bLed1);
    g_bLed1 = bLed1;
    printHtml();
}

void SensorHandler::doHead()
{
    DBG("doHead()\r\n");
}

void SensorHandler::onReadable() //Data has been read
{
    DBG("onReadable()\r\n");
}

void SensorHandler::onWriteable() //Data has been written & buf is free
{
    DBG("onWriteable()\r\n");
    close(); //Data written, we can close the connection
}

void SensorHandler::onClose() //Connection is closing
{
    DBG("onClose()\r\n");
}