/* SISTEMA DE MONITORAMENTO REMOTO para LPC1768.
 *Este código foi desenvolvido como parte de um projeto de Especialização, e utiliza varias bibliotecas
 *que estão disponiveis em https://developer.mbed.org/code/.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "SensorHandler.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "Leitura.h"
#include "Print.h"
#include "TextLCD.h"
#include "Atuadores.h"
//#include "Temporizadores.h"

Ticker to1;
Ticker to2;
Ticker to3;
Ticker Serie;
Ticker Curr;
Timer timer3;
Timer timer4;
Timer timer5;
Timer debounce;

DigitalOut led1(LED3);  // for alive check
DigitalOut Lampadas(p30);

InterruptIn Ilumin(p21);
InterruptIn ArC(p22);
InterruptIn Carreg(p23);
InterruptIn Menu(p24);

EthernetNetIf ethif( IpAddr(10,193,240,158), // IP
                     IpAddr(255,255,255,248), // Subnet mask
                     IpAddr(10,193,240,153), //Gateway
                     IpAddr(10,193,4,3) ); // DNS

/*
EthernetNetIf ethif( IpAddr(192,168,0,18), // IP
                     IpAddr(255,255,255,0), // Subnet mask
                     IpAddr(192,168,0,1),   // Gateway
                     IpAddr(192,168,0,1) ); // DNS
*/
//EthernetNetIf eth;
HTTPServer server;
Leituras sensores;
Leituras Baterias;
Leituras EnerEletrica;
Leituras Correntes1;
Leituras Correntes2;
Leituras Correntes3;
Print imprime;
Print impri;
Print Text;
Print impriCC;
Print Aviso1;
Print Aviso2;
Print clear;
//Estouro teste;
Atuadores AR;
Atuadores CARR;
Atuadores desligar;
Atuadores religar;

Serial pc(USBTX, USBRX); // tx, rx

bool g_bLed1    = false;
bool g_bHighLow = true;
bool Valor_RetornadoWeb = 0;
int  Bot_Lampada;
int  Bot_Menu;
int Item = 0;
int TravaAviso = 0;
int TravaAviso2 = 0;
int T =0;
int trava =0;
extern int CarregadorB;
extern int ArCondB;


void sensordht(void)
{
    sensores.clima();
    if ((TravaAviso == 0) && (TravaAviso2 == 0)) {
        Text.imprimeTexto();
        imprime.imprimeTemp();
    }
}

void sensorbat(void)
{
    Baterias.TensaoCC();
}

void sensorac(void)
{
    EnerEletrica.TensaoAC();
}

void sensorCorrrente (void)
{
    Correntes1.corrente();
    Correntes2.corrente2();
    Correntes3.corrente3();
}

void esperaB (void)
{
    wait_ms(200);
}

void Bmenu (void)
{
    if(debounce.read_ms()>300) {    // only allow toggle after 20 ms
        if (Bot_Menu !=1) {
            Item = Item + 1;
            if(Item == 1) {
                Text.imprimeTexto();
                imprime.imprimeTemp();
            } else if(Item == 2) {
                Text.imprimeTexto();
                impri.imprimeCurr();
            } else if(Item == 3) {
                Text.imprimeTexto();
                impriCC.imprimeCC();
                Item = 0;
            }
        }
        debounce.reset();          // restart timer after toggle
    }
}

void Blamapada (void)
{
    if(debounce.read_ms()>300) {    // only allow toggle after 20 ms
        if (Lampadas == 0) {
            Lampadas = 1;
        } else
            Lampadas = 0;
    }
    debounce.reset();          // restart timer after toggle
}

void Bar (void)
{
    if(debounce.read_ms()>300) {    // only allow toggle after 20 ms
        if (ArCondB == 0) {
            ArCondB = 1;
        } else
            ArCondB = 0;
    }
    debounce.reset();          // restart timer after toggle
}

void Bcarr (void)
{
    if(debounce.read_ms()>300) {    // only allow toggle after 20 ms
        if (CarregadorB == 0) {
            CarregadorB = 1;
        } else
            CarregadorB = 0;
    }
    debounce.reset();          // restart timer after toggle
}
void ImpSerial (void)
{
    pc.printf("\r valor X9 = %d\n",x9);
    pc.printf("\r valor X92 = %d\n",x92);
    pc.printf("\r valor retornado de gb_Led1= %d\n",g_bLed1);
    pc.printf("\r valor 2 retornado = %d\n",Valor_RetornadoWeb);
    pc.printf("\r bateria = %f\n",Tcc);
    pc.printf("\r getValor = %2.5f\n",getValor);
    pc.printf("\r Bot Carr = %d\n",CarregadorB);
    pc.printf("\r Bot Ar = %d\n",ArCondB);
    pc.printf("\r TravaAviso = %d\n",TravaAviso);
    pc.printf("\r TravaAviso = %d\n",TravaAviso2);
//    pc.printf("\r T = %d\n",T);
    pc.printf("\r Timer 3= %f sec\n", timer3.read());
    pc.printf("\r Timer 4= %f sec\n", timer4.read());
    pc.printf("\r Timer 5= %f sec\n", timer5.read());
//    pc.printf("\r corrente 3= %f\n ",sensorValue_aux3);
//    pc.printf("\r corrente 3= %s\n\n",Corrente3);
//    pc.printf("\r TEnsao AC= %f\n\n", TensAC);
 //   pc.printf("\r Estado da Lampada = %d\n\n", Lampadas);
    pc.printf("\r Estado da trava = %d\n\n", trava);
  
  }
int main()
{
    
    timer3.start();
    //  timer4.start();
    Ilumin.mode(PullUp);           //Pull up porta do botão lampada
    Menu.mode(PullUp);             //Pull up porta do botão menu
    ArC.mode(PullUp);              //Pull up porta do botão Ar
    Carreg.mode(PullUp);           //Pull up porta do botão Garreg
    to1.attach(&sensordht, 19.3);    //Temporizador de leitura do DHT22
    to2.attach(&sensorbat, 0.7);    //Temporizador de leitura das Baterias
    to3.attach(&sensorac,  5.9);
    Curr.attach(&sensorCorrrente, 1.2);
    Serie.attach(&ImpSerial, 4.0);
    debounce.start();

    Menu.fall(&Bmenu);              //aguarda a borda de decida para gerar a interrupção do menu
    Ilumin.fall(&Blamapada);        //aguarda a borda de decida para gerar a interrupção da lamapada
    ArC.fall(&Bar);                 //aguarda a borda de decida para gerar a interrupção do Ar
    Carreg.fall(&Bcarr);            //aguarda a borda de decida para gerar a interrupção do Carregador

    Menu.rise(&esperaB);            //aguarda a borda de Subida para gerar a interrupção de espera
    Ilumin.rise(&esperaB);
    ArC.rise(&esperaB);
    Carreg.rise(&esperaB);

    // EthernetNetIf setup
    if(ethif.setup()) {
        return 1;
    }
    Text.imprimeTexto();

    // Set web root path handler
    server.addHandler<SensorHandler>("/");
    // Set http port
    server.bind(80);
    Timer tmLed;
    Timer tm;
    tmLed.start();
    tm.start();

    while (1) {

        if ((( x9==1 ) || (x92 == 1)) && (TravaAviso == 0)) {
            Aviso1.imprimeAviso();
            TravaAviso = 1;
            timer4.reset();
            timer4.start();
            timer5.reset();
            timer5.start();
        }

        if((( x9==2 ) || (x92 == 2)) && (TravaAviso2 == 0)) {
            Aviso2.imprimeAviso2();
            TravaAviso2 = 1;
            timer4.reset();
            timer4.start();
            timer5.reset();
            timer5.start();
        }

        if ( (timer3.read()) > 1800) {  //tempo em segundos = 30minutos. 1800 *tempo para desligar as cargas
            T ++;
            timer3.reset();
            if(T==16) {
                desligar.Desliga();
                TravaAviso=0;
                TravaAviso2=0;
                T = 0;
            }
        }
        if ( (timer4.read()) > 30) {  //tempo em segundos = 1minuto. *tempo para apagar aviso
            TravaAviso2= 0;
            TravaAviso= 0 ;
            x9=0;
            x92=0;
            timer4.stop();
        }
        if ( (timer5.read()) > 1800) {   //tempo em segundos = 30minutos. *tempo para religar as garcas
            religar.Religa();
            timer5.stop();
        }

        AR.AtuadorAr();
        CARR.AtuadorCarr();

        Net::poll();
        if( 1.0 < tm.read() ) {
            led1 = !led1;   // high->low, low->high
            tm.start();
        }

        if( 1.0 < tmLed.read() ) {
            Valor_RetornadoWeb = g_bLed1;

            if(Valor_RetornadoWeb == true && trava == 0) {
                Lampadas = 1;
                trava = 1;
            }
            if(Valor_RetornadoWeb == false && trava == 1) {
                Lampadas = 0;
                trava = 0;
            }
            wait_ms(50);
            tmLed.start();
        }
    }
}

