#include "Leitura.h"
#include "mbed.h"
#include "DHT22.h"
#include "TextLCD.h"
#include "SensorHandler.h"

AnalogIn   sensCur(p15);
AnalogIn   sensCur2(p16);
AnalogIn   sensCur3(p17);
AnalogIn   sensCC (p18);
DigitalIn   sensAC (p27);
DHT22 sensor(p11);

DigitalOut dout(LED1);
DigitalOut myled(LED4);

int AC;
int err;
int szTemp;
int szUmid;
char szTemp2[10];   //utilizado no sensorhandler
char szUmid2[10];   //utilizado no sensorhandler
char Corrente[50];
char Corrente2[50];
char Corrente3[50];
//char Tensao[10];
char TensCC[10];
unsigned char k = 0;
unsigned char h = 0;

float sensorValue;
float sensorValue_aux;
float sensorValue2;
float sensorValue_aux2;
float sensorValue3;
float sensorValue_aux3;
float getValor;
float Tcc;
float TensAC;
float media = 0;                                //para media movel 
float filtro[10];                               //para media movel
float media2 = 0;                                //para media movel 
float filtro2[10];                               //para media movel

float       voltsporUnidade = 0.0008056640625;  //  3.3/4096
float       Vref = 3.3;
float       Vref2 = 3.11;
float       Offset = 2.3;                       //6.7;  //Tensão CC
float       salto = 0.01559;                    //0.01563;
float       DHT = 62;                           //Taxa de amostragem DHT
int         chute=0;


void Leituras::clima()
{


    sensor.sample() ;

    szTemp = (sensor.getTemperature()/10.0);
    szUmid = (sensor.getHumidity()/10.0);

}
void Leituras::corrente()
{
    sensorValue_aux = 0;
    for (int a=0; a<10; a++) {
        sensorValue_aux += sensCur.read();
    }
    sensorValue_aux = sensorValue_aux / 10;
    sensorValue = ((((sensorValue_aux * Vref2) / voltsporUnidade)-1650)/DHT) - 12.56;
    sprintf( Corrente, "%0.2f", sensorValue);
}

void Leituras::corrente2()
{
    sensorValue_aux2 = 0;

    for (int b=0; b<10; b++) {
        sensorValue_aux2 += sensCur2.read();
    }
    sensorValue_aux2 = (sensorValue_aux2 / 10);
    sensorValue2 = ((((sensorValue_aux2 * Vref2) / voltsporUnidade)-1650)/DHT) - 12.36;
    sprintf( Corrente2, "%0.2f", sensorValue2);

}

void Leituras::corrente3()
{
    sensorValue_aux3 = 0;

    for (int c=0; c<10; c++) {
        sensorValue_aux3 += sensCur3.read();
    }
    sensorValue_aux3 = sensorValue_aux3 / 10;
    sensorValue3 = ((((sensorValue_aux3 * Vref2) / voltsporUnidade)-1650)/DHT) - 12.10;
    sprintf( Corrente3, "%0.2f", sensorValue3);
}

void Leituras::TensaoCC()
{   
    Tcc = 0;
    if (chute ==0){
        Tcc= sensCC.read();
        Tcc = ((Tcc * salto) + Offset);
        chute =1;
        }
    
//media movel
   
    unsigned char j;
    filtro[k] = sensCC.read();
    k++;
    if(k==10) {
        k=0;
    }

    for(j=0; j<10; j++) {
        getValor += filtro[j];
    }
    getValor = getValor/10;
    Tcc = ((getValor * 4094) - 2048);
    Tcc = ((Tcc * salto) + Offset);
    if (Tcc < 12.1) {
        Tcc = Tcc + 0.18;
    }
    if (Tcc>= 13) {
        Tcc = Tcc - 0.06;
    }
    if (Tcc < 11.7) {
        Tcc = Tcc + 0.09;
    }
    sprintf(TensCC, "%2.2f", Tcc);


}

void Leituras::TensaoAC()
{
    float TAC = 0.0;
    TensAC = 0;
    unsigned char l;
    
    for (int w=0; w<30; w++) {
        TAC += sensAC.read();
    }
        TAC = (TAC / 30);
   
    filtro2[h] = TAC;
    h++;
    if(h==10) {
        h=0;
    }

    for(l=0; l<=10; l++) {
        TensAC += filtro2[l];
    }
    
  TensAC = TensAC * Vref;  
 //   TensAC = (TAC / 100) * Vref;
    if (TensAC != 33.0) {
        AC = 1;
    } else AC = 0 ;
}