#include "mbed.h"
#include "uLCD_4DGL.h"
#include <time.h>
#include <string>
#include "EthernetInterface.h"
 
// Definitions for networking  
const char* ECHO_SERVER_ADDRESS = "10.0.0.32";
const int ECHO_SERVER_PORT = 7;
 
// uLCD
uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;

// Mbed Leds
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

// Push Buttons
DigitalIn pb1(p23);
DigitalIn pb2(p22);
DigitalIn pb3(p21);

// Function declarations
// Screen Declarations
void StartScreen();
void ClientServerScreen();
void HelpScreen();
void InputScreen();
void EncryptionScreen();
void DecryptionScreen();
void CaesarShiftScreen();
// Actual Functions
string MorseCode(string a);

// UDP Transmission Functions 
void Client(string message);
string Server();
// Cipher declarations 
// opt => 0 Encrypt opt => 1 Decrypt
string CaesarCipher(string word,int opt, int shift);
string PolybiusSquareCipher(string a,int opt);
string PolybiusTableTranslation(char letter);
string PolybiusTableLookup(string number);

int main() {
    
    // Create pullups
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    
    // Constants 
    time_t start,end;
    double dif;
    string morseinput = "";
    string morsetranslation = "";
    string cipheredinput;
    string morsereceived = "";
    string cipherreceived = "";
    int clientserver;
    int firsttime = 0;
    int firsttimeserver = 0;
    string chosencipher = "";
    int shiftvalue = 0;
    bool inserting = true;
    EthernetInterface ethclient;
    EthernetInterface ethserver;
    const char * IPaddress = "10.0.0.32";  // 10.10.0.65
    const char * NetworkMask = "255.255.255.0";
    const char * Gateway = "10.0.0.1";   // 10.10.0.1
    
    // Welcome Screen
    StartScreen();
    
    // pb1 => up 
    // pb2 => down 
    // pb3 => right
    // 0 - Client
    // 1 - Server
    while(true)  // Infinite Loop. Restart at ClientServerScreen.
    {
        morseinput = "";
        morsetranslation = "";
        morsereceived = "";
        cipherreceived = "";
        clientserver = 0;
        uLCD.cls();
        ClientServerScreen();
        shiftvalue = 0;
        while(pb2 && pb1)
        {
        }
        
        if(!pb1) // pb1 was pressed, do Client Network
        {
            clientserver = 0;
        }
        else if(!pb2)
        {
            clientserver = 1; // pb2 was pressed, do Server Network
        }
        
        if(clientserver == 0)
        {
            uLCD.cls();
            if(firsttime==0)
            {
                HelpScreen();
            }
            uLCD.cls();
            InputScreen();
            // Input Morse Code below. pb1 to input. 
            // pb2 to move to the next step
            start = 0;
            end = 0;
            while(pb3)
            {
                
                if(!pb1) // Means a dot was inserted
                {
                    while(!pb1) // Need to wait until the button is released
                    {             
                    }
                    morseinput.append("."); 
                    inserting = true;  
                    time(&start);
                }
                else if(!pb2)
                {
                    while(!pb2) // Need to wait till release
                    {             
                    }
                    morseinput.append("-"); 
                    inserting = true;
                    time(&start); 
                }
                
                if(start !=0.0)
                {
                  time(&end);
                  dif = difftime(end,start);
                  if(dif>1)
                  {
                      string e = MorseCode(morseinput);
                      if(e!="error")
                      {
                          morsetranslation.append(e);
                          uLCD.printf("%s",e);
                      }
                      start = 0;
                      end = 0;
                      morseinput = "";
                    }
                }
            }
            
            uLCD.cls();
            EncryptionScreen();
            
            while(pb2 && pb1 && pb3)
            {
            }
            
            if(!pb1) // pb1 was pressed, do caesar cipher
            {
                uLCD.cls();
                CaesarShiftScreen();
                shiftvalue = 0;
                uLCD.locate(0,4);
                uLCD.printf("%02d",shiftvalue);
                while(pb3)
                {
                    if(!pb1) // Means go up one value
                    {
                        while(!pb1) // Need to wait until the button is released
                        {             
                        }
                        shiftvalue = shiftvalue + 1;
                        if(shiftvalue>25)
                        {
                            shiftvalue = 25;   
                        }
                        uLCD.locate(0,4);
                        uLCD.printf("%02d",shiftvalue);
                    }
                    if(!pb2) // Means go up one value
                    {
                        while(!pb2) // Need to wait until the button is released
                        {             
                        }
                        shiftvalue = shiftvalue - 1;
                        if(shiftvalue<0)
                        {
                            shiftvalue = 0;   
                        }
                        uLCD.locate(0,4);
                        uLCD.printf("%02d",shiftvalue);
                    }
                }
                cipheredinput = CaesarCipher(morsetranslation,0,shiftvalue);
                chosencipher = "Caesar Cipher";
            }
            else if(!pb2) // pb2 was pressed, do Polybius Square cipher
            {  
                cipheredinput = PolybiusSquareCipher(morsetranslation,0);
                chosencipher = "Polybius Sqre";
            }
            else if(!pb3)  // No Cipher
            {
                cipheredinput = morsetranslation;  
                chosencipher = "No Cipher";
            }
            wait(2);
            
            // Once the morse input comes in through here. 
            // Tell the user that we are about to send it all. 
            uLCD.cls();
            uLCD.printf("%s\n",chosencipher);
            uLCD.printf("Sending Value\n\n");
            uLCD.printf("\n%s\n",morsetranslation);
            uLCD.printf("\n%s\n",cipheredinput);
            wait(3);
            
            if(firsttime == 0)
            {
                ethclient.init();
                firsttime = 1;
            }

            ethclient.connect();
            UDPSocket sock;
            sock.init();
            Endpoint echo_server;
            echo_server.set_address(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
            char out_buffer[1024];
            strncpy(out_buffer, cipheredinput.c_str(), sizeof(out_buffer));
            out_buffer[sizeof(out_buffer) - 1] = 0;
            //uLCD.printf("\Client IP Address is %s\n", ethclient.getIPAddress());
            //wait(4);
            sock.sendTo(echo_server, out_buffer, sizeof(out_buffer));
            sock.close();
            ethclient.disconnect();
            // technically the eth should still be connected
            uLCD.cls();
            uLCD.printf("Message has been sent");
            wait(2);
        }
        else
        {
            uLCD.cls();    
            uLCD.printf("Receiving...");  

            if(firsttimeserver == 0)
            {
                //uLCD.printf("first time server");
                ethserver.init(IPaddress, NetworkMask, Gateway); 
                firsttimeserver = 1;
            }
            //uLCD.printf("initialized");
            ethserver.connect();
            UDPSocket server;
            server.bind(ECHO_SERVER_PORT);
            Endpoint client;
            char buffer[256];
            //uLCD.printf("\Server IP Address is %s\n", ethserver.getIPAddress());
            string message;
            int n = server.receiveFrom(client, buffer, sizeof(buffer));
            buffer[n] = '\0';
            
            string message2(buffer);
            server.close();
            ethserver.disconnect();          
            uLCD.cls();
            uLCD.printf("Message %s",message2);
            wait(3);
            morsereceived = message2;
            // string morsereceived = "";
            // string cipherreceived = "";
            
            // After Reception, User will have 2 options to decipher
            // Engima or Caesar. 
            uLCD.cls();
            DecryptionScreen();
            while(pb2 && pb1 && pb3)
            {
            }
            
            if(!pb1) // pb1 was pressed, do caesar cipher
            {
                uLCD.cls();
                CaesarShiftScreen();
                shiftvalue = 0;
                uLCD.locate(0,4);
                uLCD.printf("%02d",shiftvalue);
                while(pb3)
                {
                    if(!pb1) // Means go up one value
                    {
                        while(!pb1) // Need to wait until the button is released
                        {             
                        }
                        shiftvalue = shiftvalue + 1;
                        if(shiftvalue>25)
                        {
                            shiftvalue = 25;   
                        }
                        uLCD.locate(0,4);
                        uLCD.printf("%02d",shiftvalue);
                    }
                    if(!pb2) // Means go up one value
                    {
                        while(!pb2) // Need to wait until the button is released
                        {             
                        }
                        shiftvalue = shiftvalue - 1;
                        if(shiftvalue<0)
                        {
                            shiftvalue = 0;   
                        }
                        uLCD.locate(0,4);
                        uLCD.printf("%02d",shiftvalue);
                    }
                }
                cipherreceived = CaesarCipher(morsereceived,1,shiftvalue); // Second input = 1, for decryption
            }
            else if(!pb2) // pb2 was pressed, do Polybius Square Cipher
            {  
                cipherreceived = PolybiusSquareCipher(morsereceived,1);  // Second input = 1, for decryption
            }
            else if(!pb3)
            {
                cipherreceived = morsereceived;   
            }
            uLCD.cls();
            uLCD.printf("Decryption\n\n");
            uLCD.printf("%s\n",morsereceived);
            uLCD.printf("%s\n",cipherreceived);
            wait(5);
        }
    }
}


// Start Screen to show Welcome Page
void StartScreen()
{
    uLCD.printf("Welcome to the Morse Code Enconder and Transmitter.\n\n\n");
    wait(4);    
}

// Screen to choose between Client and Servers
void ClientServerScreen()
{
    uLCD.printf("Choose an option:\n\n");
    uLCD.printf("1 - Transmit\n");
    uLCD.printf("2 - Receive\n");
    //uLCD.printf("3 - Checkers\n");
}

// Screen 2
void HelpScreen()
{
    uLCD.printf("Up => . \n\n");
    uLCD.printf("Down => - \n\n");
    uLCD.printf("Right => Submit\n");
    wait(2);
}

// Screen 3
void InputScreen()
{
    uLCD.printf("Input Morse Code\n");   
}

// Screen 4
void EncryptionScreen()
{
    uLCD.printf("Choose encryption:\n\n");
    uLCD.printf("1 - Caesar Cipher\n");
    uLCD.printf("2 - Polybius Sqre\n");
    uLCD.printf("3 - No cipher\n");
}

void DecryptionScreen()
{
    uLCD.printf("Choose decryption:\n\n");
    uLCD.printf("1 - Caesar Cipher\n");
    uLCD.printf("2 - Polybius Sqre\n");
    uLCD.printf("3 - No cipher\n");
}

void CaesarShiftScreen() {
    uLCD.printf("Choose a shift value\n");
    uLCD.printf("UP and DOWN");
}

// Returns the proper character based on the inputed morse code
string MorseCode(string a)
{
    //uLCD.printf("%s",a);
    if(a == ".-") { return "A";}
    if(a == "-...") { return "B";}
    if(a == "-.-.") { return "C";}
    if(a == "-..") { return "D";}
    if(a == ".") { return "E";}
    if(a == "..-.") { return "F";}
    if(a == "--.") { return "G";}
    if(a == "....") { return "H";}
    if(a == "..") { return "I";}
    if(a == ".---") { return "J";}
    if(a == "-.-") { return "K";}
    if(a == ".-..") { return "L";}
    if(a == "--") { return "M";}
    if(a == "-.") { return "N";}
    if(a == "---") { return "O";}
    if(a == ".--.") { return "P";}
    if(a == "--.-") { return "Q";}
    if(a == ".-.") { return "R";}
    if(a == "...") { return "S";}
    if(a == "-") { return "T";}
    if(a == "..-") { return "U";}
    if(a == "...-") { return "V";}
    if(a == ".--") { return "W";}
    if(a == "-..-") { return "X";}
    if(a == "-.--") { return "Y";}
    if(a == "--..") { return "Z";}
    if(a == ".----") { return "1";}
    if(a == "..---") { return "2";}
    if(a == "...--") { return "3";}
    if(a == "....-") { return "4";}
    if(a == ".....") { return "5";}
    if(a == "-....") { return "6";}
    if(a == "--...") { return "7";}
    if(a == "---..") { return "8";}
    if(a == "----.") { return "9";}
    if(a == "-----") { return "0";}
    return "error";
}

// Cipher Codes by Ishita 



// Find the length of the string
// Loop through it, and replace each a[i] with its equivalent that is 3 letters later. 
// For that will have to loop through Alphabet and find the position of said letter. 
// Then increment. So hopefully there is a isin(alphabet,"A) -> that returns the index, position etc.
string CaesarCipher(string word, int opt, int shift)
{
    string alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    if(opt == 0) // Encrypt
    {   
        string encrypted = "";
        for (int x = 0; x < word.length(); x++) {
            char c = word[x];
            int ind = alphabet.find(c);
            ind = (ind + shift) % 26;
            encrypted += alphabet[ind];
        }
        return encrypted; 
    }  else if (opt == 1) { //Decrypt
        string decrypted = "";
        for (int x = 0; x < word.length(); x++) {
            char c = word[x];
            int ind = alphabet.find(c);
            ind = (ind - shift) % 26;
            decrypted += alphabet[ind];
        }
        return decrypted;
    } else {
        return "Error";
    }
}

//Polybius Square cipher
string PolybiusSquareCipher(string word,int opt)
{
    string number = "";
    string numbers = "";
    if(opt == 0) // Encrypt
    {   
        string encrypted = "";
        string rows = "";
        string cols = "";
        for (int x = 0; x < word.length(); x++) {
            char c = word[x];
            number = PolybiusTableTranslation(c);
            rows += number[0];
            cols += number[1]; 
        }
        numbers = rows + cols;
        for (int y = 0; y < numbers.length(); y = y + 2) {
            encrypted += PolybiusTableLookup(numbers.substr(y,2));
        }
        return encrypted; 
    }  else if (opt == 1) { //Decrypt
        string decrypted = "";
        for (int x = 0; x < word.length(); x++) {
            char c = word[x];
            number = PolybiusTableTranslation(c);
            numbers += number;
        }
        int length = numbers.length()/2;
        for (int y = 0; y < length; y++) {
            string newNum = "";
            newNum += numbers[y];
            newNum += numbers[y + length];
            decrypted += PolybiusTableLookup(newNum);
        }
        return decrypted;
    } else {
        return "Error";
    }
}



string PolybiusTableTranslation(char letter) {
    if (letter == 'A') {return "11";}
    if (letter == 'B') {return "12";}
    if (letter == 'C') {return "13";}
    if (letter == 'D') {return "14";}
    if (letter == 'E') {return "15";}
    if (letter == 'F') {return "21";}
    if (letter == 'G') {return "22";}
    if (letter == 'H') {return "23";}
    if (letter == 'I') {return "24";}
    if (letter == 'J') {return "24";}
    if (letter == 'K') {return "25";}
    if (letter == 'L') {return "31";}
    if (letter == 'M') {return "32";}
    if (letter == 'N') {return "33";}
    if (letter == 'O') {return "34";}
    if (letter == 'P') {return "35";}
    if (letter == 'Q') {return "41";}
    if (letter == 'R') {return "42";}
    if (letter == 'S') {return "43";}
    if (letter == 'T') {return "44";}
    if (letter == 'U') {return "45";}
    if (letter == 'V') {return "51";}
    if (letter == 'W') {return "52";}
    if (letter == 'X') {return "53";}
    if (letter == 'Y') {return "54";}
    if (letter == 'Z') {return "55";}
    
    return "error";
}

string PolybiusTableLookup(string number) {
    if (number == "11") {return "A";}  
    if (number == "12") {return "B";}  
    if (number == "13") {return "C";}
    if (number == "14") {return "D";}
    if (number == "15") {return "E";}
    if (number == "21") {return "F";}
    if (number == "22") {return "G";}
    if (number == "23") {return "H";}
    if (number == "24") {return "I/J";}
    if (number == "25") {return "K";}
    if (number == "31") {return "L";}
    if (number == "32") {return "M";}
    if (number == "33") {return "N";}
    if (number == "34") {return "O";}
    if (number =="35") {return "P";}
    if (number == "41") {return "Q";}
    if (number == "42") {return "R";}
    if (number == "43") {return "S";}
    if (number == "44") {return "T";}
    if (number == "45") {return "U";}
    if (number == "51") {return "V";}
    if (number == "52") {return "W";}
    if (number == "53") {return "X";}
    if (number == "54") {return "Y";}
    if (number == "55") {return "Z";}
 
    return "error";
}




