#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include <string>
#include "rtos.h"

// ULCD
uLCD_4DGL uLCD(p9,p10,p17); // serial tx, serial rx, reset pin;

// Speaker Output
AnalogOut DACout(p18);
wave_player waver(&DACout);

// SD Cards
SDFileSystem sd(p5, p6, p7, p8, "sd");

// Paddle Left
AnalogIn photocellleft(p15);
// Paddle Right
AnalogIn photocellright(p16);

//std::string a
void Sound(std::string event){
    FILE *wave_file;
    
    if(event == "hit")
        wave_file=fopen("/sd/wavfiles/pac_bonus.wav","r");
    else if(event == "end")
        wave_file=fopen("/sd/wavfiles/BUZZER.wav","r");
    else if(event == "start")
        wave_file=fopen("/sd/wavfiles/BUZZER.wav","r");
        
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
 }
 
int border = 128;
int paddlesizex = 5;
int paddlesizey = 20;
int paddlecolor = 0x00FF00;
int ballradius = 3;
int ballcolor = 0xFF00FF;
int black = 0x000000;

// Paddle left

int paddlelx = 0;
int paddlely = 0;
int paddlerx = border-paddlesizex;
int paddlery = 50;

int oldpaddlely = paddlely;
int oldpaddlery = paddlery;

int paddlelincr = 1;
int paddlerincr = 1;

// Ball x,y , should be randomized to begin
int ballx = border/2;
int bally = rand() % 100; 

int oldballx = ballx;
int oldbally = bally;
    // Increments for ball
int ballxincr = -1;
int ballyincr = -1;

int oldphotocell = photocellleft;

int hitvariable = 0;

// Threading
void function_thread3(void const *name){
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    while(true){
        if(hitvariable == 1){
            wave_file=fopen("/sd/wavfiles/pac_bonus.wav","r");
            waver.play(wave_file);
            fclose(wave_file);
            hitvariable = 0;
            //wait(.2);
        }
    }
 }
 
 // ULCD Functions
void DrawPaddle(int x, int y,int color){
       // Green paddles
       uLCD.filled_rectangle(x, y, x+paddlesizex, y+paddlesizey, color);
}

void DrawBall(int x, int y,int color){
    uLCD.filled_circle(x, y, ballradius, color);
}

int main() {
    // Begin the game
    Sound("start");
    
    // Thread for Sound
    Thread thread3(function_thread3);
    
    // Baudrate
    uLCD.baudrate(300000);
    int initialphotocell = photocellleft*100/2;
    //uLCD.printf("%d",initialphotocell);
    //wait(10);
    // Rectangle
    DrawPaddle(paddlelx,paddlely,paddlecolor);
    //wait(5);
    DrawPaddle(paddlerx,paddlery,paddlecolor);
    
    DrawBall(ballx,bally,ballcolor);
    
    while(true){
        // Update Positions
        oldballx = ballx;
        oldbally = bally;
        ballx += ballxincr;
        bally += ballyincr;
        oldpaddlely = paddlely;
        oldpaddlery = paddlery;
        paddlely += paddlelincr;
        paddlery += paddlerincr;
        
        // Ball Collision with right wall
        if(ballx+ballradius>=border){
            // Lose
            //ballxincr = -2;
            Sound("end");
            ballx = border/2;
            bally = rand() % 100;
            ballxincr = -1;
            ballyincr = -ballyincr;
            //hitvariable = 1;
            //Sound("hit");
        }
        // Ball Collision with left wall
        else if(ballx<=0){
            // Lose
            Sound("end");
            ballx = border/2;
            bally = rand() % 100;
            ballxincr = 1;
            ballyincr = -ballyincr;
            //hitvariable = 1;
            //Sound("hit");
        }
        // Ball Collision with top and Bottom
        if(bally+ballradius>=border){
            ballyincr = -1;
            hitvariable = 1;
            //Sound("hit");
        }
        else if(bally<=0){
            ballyincr = 1;
            hitvariable = 1;
            //Sound("hit");
        }
        
        // Left Paddle Collisions
        if(ballx-ballradius<=paddlelx+paddlesizex && bally+ballradius>paddlely && bally-ballradius<paddlely+paddlesizey){
          ballxincr = 1;
        }
        // Right Paddle Collision
        else if(ballx+ballradius>=paddlerx && bally+ballradius>paddlery && bally-ballradius<paddlery+paddlesizey){
          ballxincr = -1;
        }
        // Paddle not fall off the screen
        if(paddlely<0){
          paddlely = 0;
          //paddlelincr = 1;
        }
        else if(paddlely+paddlesizey>=border){
          paddlely = border - paddlesizey;
          //paddlelincr = -1;
        }
        if(paddlery<=0){
          paddlery = 0;
          //paddlerincr = 1;
        }
        else if(paddlery+paddlesizey>=border){
          paddlery = border - paddlesizey;
          //paddlerincr = -1;
        }
        // Get light from Photocells
        if(photocellleft*100 >initialphotocell)
        {
            paddlelincr = -2;   
        }
        else
        {
            paddlelincr = 2;   
        }
        if(photocellright*100 > initialphotocell)
        {
            paddlerincr = -2;   
        }
        else
        {
            paddlerincr = 2;   
        }
        //oldphotocell = photocell;
        DrawBall(oldballx,oldbally,black);
        DrawBall(ballx,bally,ballcolor);
        DrawPaddle(paddlelx,oldpaddlely,black);
        DrawPaddle(paddlerx,oldpaddlery,black);
        DrawPaddle(paddlelx,paddlely,paddlecolor);
        DrawPaddle(paddlerx,paddlery,paddlecolor);
    }
}














