#include "mbed.h"

AnalogIn in(A0);

#if !DEVICE_ANALOGOUT
#error You cannot use this example as the AnalogOut is not supported on this device.
#else
AnalogOut out(PA_4);
#endif

DigitalOut led(LED1);

int main()
{
    printf("\nAnalog loop example\n");
    printf("*** Connect A0 and PA_4 pins together ***\n");
    while(1) {
        for (float out_value = 0.0f; out_value < 1.1f; out_value += 0.1f) {
            // Output value using DAC
            out.write(out_value);
            wait(0.1);
            // Read ADC input
            float in_value = in.read();
            // Display difference between two values
            float diff = fabs(out_value - in_value);
            printf("(out:%.4f) - (in:%.4f) = (%.4f) ", out_value, in_value, diff);
            if (diff > 0.05f) {
                printf("FAIL\n");
            } else {
                printf("OK\n");
                printf("\033[1A"); // Moves cursor up of 1 line
            }
            led = !led;
        }
    }
}

