#include "mbed.h"
#include "ble/BLE.h"
#include "ble/services/UARTService.h"
#include "Serial.h"
#include "stdlib.h"

#define UART_BUFFER (UARTService::BLE_UART_SERVICE_MAX_DATA_LEN)


const static char DEVICE_NAME[] = "OBCP";
UARTService *uartServicePtr;

//PWM output
PwmOut Green(PC_8);              //PWM Red LED
PwmOut Red(PC_6);              //PWM Red LED
PwmOut Blue(PC_9);              //PWM Red LED

// Def Peripheriques
InterruptIn myButton(PC_13);    // USER BUTTON

///////////Init HC05/////////////////
Serial HC05(D8, D2);
//Bluetooth
//Maitre (Arrivee) : ADDR = 98d3,b1,fd5c5d
//Esclave (Départ) : ADDR = 0019,10,08FCB5
/////////////////////////////////////
//Ticker t;
////////////TIMER////////////////////
Timer timer;
int begin;
int end;
float chrono=0;
void Timer_triggered()
{
    timer.start();
    begin = timer.read_ms();
    Blue=1;
    wait(0.5);
    Blue=0;
}
void Timer_Reset()
{
    timer.stop();
    begin=0;
    end=0;
    chrono=0;
}
/////////////////////////////////////


/////////COMMUNICATION///////////////
void HC05_receive()
{
    char IncomingValue = HC05.getc();
    if(IncomingValue == 'u') {
        end = timer.read_ms();
        timer.stop();
        chrono = end-begin;

    }
}
/////////////////////////////////////







// Tableau et index de communication avec UART
static char uartBuff[UART_BUFFER];
// Routine de traitement des erreurs
void onBleError(ble_error_t error);

/****************************************************/
/* Ticker actif lorsque la connexion BLE est présente */
/****************************************************/

void update(void)
{
    char train[5];
    float chrono_value = float(chrono)* 0.001F;

    //Transformation des valeurs numeriques en chaine de caracteres
    sprintf(train,"%5.2f",chrono_value);
    //Integre les trois chaines de caractere contenant les ts dans la chaine uartBuff
    sprintf(uartBuff, "%s", train) ;
    //Envoie la chaine uartBuff sur le sevice TX UART BLE
    uartServicePtr->write(uartBuff, UARTService::BLE_UART_SERVICE_MAX_DATA_LEN);
    // Réinitialiser la chaîne uartBuff en entrant 0 dans les premiers caractères UART_BUFFER
    memset(uartBuff, 0, UART_BUFFER);

}

/*************************/
/* Connexion BLE réussie */
/*************************/
void BleConnectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
    Timer_Reset();
    update();
}

/*****************************/
/* Déconnexion du client BLE */
/*****************************/
void BleDisconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    (void)params;
    // Redémarrer la publicité
    Timer_Reset();
    update();
    
    BLE::Instance().gap().startAdvertising();
    
    Blue.write(0.0f);
    Green.write(0.0f);
    Red.write(0.0f);
}

/***************************/
/* Rx de BLE et Rx vers USB*/
/***************************/

void BleOnDataWrittenCallback(const GattWriteCallbackParams *params)
{
    char reception[UART_BUFFER];
    char commande[3];

    // Reçoit une chaîne de BLE
    if (params->handle == uartServicePtr->getTXCharacteristicHandle()) {
        // Copie de la chaine reçue dans reception
        sprintf(reception,"%s", params->data);
        // Copie dans la chaine commande des deux premier caracteres de la chaine reception
        sprintf(commande,"%c%c%c", reception[0], reception[1], reception[2]);
        if( strcmp(commande, "RST" )==0 or strcmp(commande, "rst" )==0 ) {
            Timer_Reset();
            update();
        }
    }
}


/***************************/
/* Erreur sur le canal BLE */
/***************************/

void onBleError(ble_error_t error)
{
    Red.period(0.8f);  // période = 0.8 seconde
    Red.write(0.10f);  // élaire 10% de la période
    /* Entrer le traitement des erreurs */
}

/**************************************/
/* Initialisation du service BLE UART */
/**************************************/

void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {

        /* En cas d'erreur, transmettez le traitement d'erreur à onBleInitError*/
        onBleError(error);
        return;
    }

    /* Assurez-vous qu'il s'agit de l'instance par défaut de BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }

    ble.gap().onConnection(BleConnectionCallback);
    ble.gap().onDisconnection(BleDisconnectionCallback);
    ble.gattServer().onDataWritten(BleOnDataWrittenCallback);

    /* Configuration du service primaire. */
    UARTService uartService(ble);
    uartServicePtr = &uartService;

    /* Configurer la publicité */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(500); /* 500ms. */
    ble.gap().startAdvertising();

    // Attend les événements sur BLE
    while (true) {
        ble.waitForEvent();
        update();
        while(HC05.readable()) {
            HC05_receive();
        }
        wait(0.01);
    }
}

/********/
/* MAIN */
/********/
int main(void)
{
    HC05.baud(38400);
    myButton.fall(&Timer_triggered);

    // Initialiser LED
    Green.write(0.0f);
    Red.write(0.0f);
    Blue.write(0.0f);

    /****** START Initialiser BLE **********/
    BLE &ble = BLE::Instance();
    ble.init(bleInitComplete);
    /******* FIN initialise BLE ***********/
}

