//Includes

#include "mbed.h"
#include "SimpleBLE.h"


///////////Init STM32 pins///////////
DigitalOut myLed(PC_8);
DigitalIn my_button(PC_13);  //User1
/////////////////////////////////////




///////////Init HC05/////////////////
Serial HC05(PA_2, PA_3);
//Bluetooth
//Maitre (Tanguy) : ADDR = 0019,10,08FCD3
//Esclave (Dorian) : ADDR = 0019,10,08FCB5
/////////////////////////////////////




//////////////Init BLE///////////////
SimpleBLE ble("ObCP_CROC_ENSMM");

/////////////READ////////////////////
SimpleChar<float> trigger_value = ble.readOnly_float(0xA000, 0xA002);
SimpleChar<float> chrono_value = ble.readOnly_float(0xA000, 0xA003);
/////////////////////////////////////




////////////TIMER////////////////////
Timer timer;
int begin;
int end;
float chrono=0;
void Timer_triggered()
{
    timer.start();
    begin = timer.read_ms();
}
void Timer_Reset()
{
    timer.stop();
    begin=0;
    end=0;
    chrono=0;
}
/////////////////////////////////////




/////////COMMUNICATION///////////////
void HC05_receive()
{
    char IncomingValue = HC05.getc();
    if(IncomingValue == 'u') {
        end = timer.read_ms();
        timer.stop();
        chrono = end-begin;

    }
    HC05.putc(IncomingValue);
}
/////////////////////////////////////




/////////////GAMEMODES///////////////
void solo()
{
    trigger_value = float(my_button);
    chrono_value = float(chrono)* 0.001F;


    if (my_button==0) {
        Timer_triggered();
        myLed=1;
    } else {
        myLed = 0;
    }
    //while bluetooth device is receiving data
    while(HC05.readable()) {
        HC05_receive();
    }
}
/////////////////////////////////////




/////////GAMEMODES UPDATE////////////
float gamemode = 0;
void updateGM(float newValue)
{
    gamemode = newValue;
}
SimpleChar<float> gamemode_command = ble.writeOnly_float(0xA000, 0xA004, &updateGM);
/////////////////////////////////////








int main(int, char**)
{
    HC05.baud(9600);
    ble.start();
    while (1) {
        ble.waitForEvent();
        solo();

    }
}







