#include "mbed.h"
#include <math.h>  
#include "TSISensor.h"
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define ARGUMENTSTATE 0
#define ANSWERSTATE 1
#define TSILIMIT 0.01
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define BUTTONTIME 0.1
#define PROGNAME "kl46z_slider_mid_v1\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer dataTimer;
Timer ButtonTimer; // for reading button states
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
float tsidata;
int displayState;

float newtonSqrt(float argument){
#define MAXITER 20
    int i = 0;
    float xnew = 0.0;
    int itermax = MAXITER;
    float epsilon = EPSILONC;
    float xold = argument/2.0;
    float delta = 1;
    intmax = 20
    epsilon = 1e-7
    #xold = float(a/2.5)# make a guess5

    for interations in range(0,intmax):
        xnew = 0.5*(xold + (a/xold)) # Calculation
        delta = abs(xnew-xold) # Compare old and new values
        
        if delta < epsilon: # Check for convergence
            break
        else:
            xold = xnew # replace new calculated value to redo the calculation
    
   return(xnew);
}

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    dataTimer.start();
    dataTimer.reset(); 
} 

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

int main(void) {
    int i;
    char lcdData[LCDCHARLEN];
    float lastTouch = 0.0;
    TSISensor tsi;
    float tempTSI;
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    
    initialize_global_vars();

     while (true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    displayState = i;
                    // do something here.
                    
                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
            lcdArgument = tsidata * 100;
            sprintf (lcdData,"%0.4f",tsidata);  
            LCDMess(lcdData); 
            rled = 0.0;
            gled = 1.0;
            
        }
        if(dataTimer.read() > DATAINTERVAL){
            dataTimer.reset();                               
            tempTSI = tsi.readPercentage();        
            if (tempTSI > TSILIMIT){
                tsidata = tempTSI;
                if (fabs(tsidata - lastTouch)> PRINTDELTA){
                    pc.printf("Position %0.4f\n\r", tsidata);
                }           
            }
            lastTouch=tsidata;
        }
    }
}
