#include "mbed.h"
#include <math.h>  
#include "TSISensor.h"
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define ARGUMENTSTATE 0
#define ANSWERSTATE 1
#define TSILIMIT 0.01
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define BUTTONTIME 0.1
#define PROGNAME "kl46z_slider_Counter_Program_v1\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer dataTimer;
Timer ButtonTimer; // for reading button states
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
int displayState = ARGUMENTSTATE;
float tsidata;
float lcdArgument;
float countOut;
  
//while {(AbsoluteDistancePosition>=min_num) && (AbsoluteDistancePosition<=max_num)
//    backward_count()=AbsoluteDistancePosition-delta;
//    }
    
float backward_count(lcdArgument):
    lcdArgument = 0;
    float delta=2;
    float min_num=2;
    float max_num=50; 
 
    if (n <= min_num)  && (n >= max_num){
        return
    else:
        return backward_count(n-delta, delta, min_num)
        pc.printf("%5.4f", backward_count)
        }

def main():
    number = 25
    increment = 2
    min_number = -5
    backward_count(number,increment, min_number)


void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    dataTimer.start();
    dataTimer.reset(); 
} 

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

int main(void) {
    int i;
    char lcdData[LCDCHARLEN];
    float lastTouch = 0.0;
    TSISensor tsi;
    float tempTSI;
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    
    initialize_global_vars();

     while (true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    displayState = i;
                    // do something here.
                    
                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
            swtich (displayState){
                case ARGUMENTSTATE : {
                    lcdArgument = tsidata * 100;
                    sprintf (lcdData, "%4.1f", lcdArgument);
                    LCDMess(lcdData);
                    rled = 0.0;
                    gled = 1.0;
                    break;
                    }
                case ANSWERSTATE : {
                    countOut = backward_Count(lcdArguemnt)
                    sprintf (lcdData,"%0.4f", countOut);
                    LCDMess(lcdData);
                    rled = 0.0;
                    gled = 1.0;
                    break;
                    }
                  }
                }
                    
        if(dataTimer.read() > DATAINTERVAL){
            dataTimer.reset();                               
            tempTSI = tsi.readPercentage();        
            if (tempTSI > TSILIMIT){
                tsidata = tempTSI;
                if (fabs(tsidata - lastTouch)> PRINTDELTA){
                    pc.printf("Position %0.4f\n\r", tsidata);
                }           
            }
            lastTouch=tsidata;
        }
    }
}