#include "mbed.h"
#include "TSISensor.h"
#include "SLCD.h"
#define TSILIMIT 0.99
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define PROGNAME "kl46z_slider_test_v1\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

float tsidata;

void LCDMess(char *lMess){
    slcd.Home();
    slcd.clear();
    slcd.printf(lMess);
}

int main(void) {
    char lcdData[LCDCHARLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    pc.printf(PROGNAME);
    TSISensor tsi;

    Timer LEDTimer;
    Timer ButtonTimer;

    while(true) {
        buttonTimer = tsi.readPercentage();
        if (ButtonTimer > Buttontime) {
            for (i = 0; i < TSILIMIT; i++) { //i am hoping this makes the index 0 or 1
                if (!buttons[i]) {
                    allLEDsoff();
                    LCDMess(rMess[i]);
                    pc.printf(pMess[i]);
                    currentLED = i;
                }
            }
            ButtonTimer.reset();
        }
        if (LEDTimer.read() > blinkTimes[ledState]) {
            LEDTimer.reset();
            ledState = !ledState;
            LEDs[currentLED] = ledState;
            }
        }

    }