#include "mbed.h"
#include <math.h> 
#include "MMA8451Q.h"
#include "SLCD.h"
#define NUMBUTS 2
#define RBUT PTC3
#define LBUT PTC12  // port addresses for left button
#define BUTTONTIME 0.1
/* 
Test of the accelerometer, digital I/O, on-board LCD screen.
 Looing at vector product of the x-y components of the accelerometer.
 Works pretty well. Still rough, program wise - sc 140710
 */

#define DATAINTERVAL 0.200
#define LCDDATALEN 10
#define xAxis 0
#define yAxis 1
#define zAxis 2

#define PROGNAME "ACCLCD341-541\r\n"

#define PRINTDBUG
// 
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;  // Data pins for the accelerometer/magnetometer.
  PinName const SCL = PTE24;  // DO NOT CHANGE
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

SLCD slcd; //define LCD display
char lcdData[LCDDATALEN]; //buffer needs places dor decimal pt and colon

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
Serial pc(USBTX, USBRX);
Timer dataTimer;
Timer ButtonTimer;

int displayState;
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
DigitalIn button(LBUT);
   

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void LCDsignedFloat(float theNumber){
    sprintf (lcdData," %3.2f",theNumber); 
    if (theNumber < 0.0) sprintf (lcdData,"<%3.2f",fabs(theNumber));   
    LCDMess(lcdData); 
} 

void initialize_global_vars(){
    pc.printf(PROGNAME);
    dataTimer.start();
    dataTimer.reset(); 
} 

int main() {
    float xAcc;
    float yAcc; 
    float zAcc;
    xAcc = acc.getAccX();
    yAcc = acc.getAccY(); 
    zAcc = acc.getAccZ();    
    
    initialize_global_vars();
// main loop forever 
  //Get accelerometer data - tilt angles minus offset for zero mark.
    while (true) {
        if (ButtonTimer > BUTTONTIME){
            //buttonValue = !buttons[1].read();
            //pc.printf("%d \r\n",buttonValue);
            for (int i=0; i < NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) {
                    displayState = i;
                    switch (displayState){  // this keeps things generic           
                         case xAxis:
                         LCDsignedFloat(xAcc);
                         break;
                         case yAxis:
                         LCDsignedFloat(yAcc);
                         break;
                         case zAxis:
                         LCDsignedFloat(zAcc);
                         i=-1;
                         break;
                    }   
                }}
                 // if ! buttons   
 
#ifdef PRINTDBUG
        pc.printf("xAcc = %f\r\n", xAcc);
        pc.printf("yAcc = %f\r\n", yAcc);
        pc.printf("zAcc = %f\r\n", zAcc);
        pc.printf("LBUT = %f\r\n", LBUT);
#endif

// Wait then do the whole thing again.
    }
    }}