// pour faire 1 tour on fait 34(nombre de crans pour 1 tour)*Mcran*vitesse
// sa represente le temp pour faire un tour

#include "mbed.h"
#define Mcran 0.01099       //distance par cran en metre
#define vitesse  0.7        //vitesse en m/s (a remesurer avec le robot sur piste)
#define vmot1TOUR 50        // rapport cyclique 50%
#define vmot2TOUR -50       //rappot cyclique de -50%
#define vmot_avance 50
#define vmot_recule -50
#define vmot_stop 0
Serial DebugUART(USBTX, USBRX);
Serial BTH(p13,p14);        //module bleutooth tx,rx
Timer T1;                   //utiliser pour faire un tour
Timer T2;                   //utiliser pour faire un demi tour
PwmOut mot1(p23);           // mot droit
PwmOut mot2(p22);           //mot gauche
DigitalOut sens_droit(p11); // definir le sens du moteur droit
DigitalOut sens_gauche(p12);// definir le sens du moteur gauche
void sens_vitesse(int,int);   // gestin du sens et de la vitesse et du moteur 1 periode entre [-100;100] puis le moteur 1=droit 2=gauche
int main(void)
{
    float Ttour=1.40;//34*0.01099*0.7;// calcul du temps mis pour faire un tour
    float Tdemi=0.70;//17*0.01099*0.7;//calcul du temps mis pour faire un demi tour
    //printf("Ttour=%g",Ttour);
    //printf("Tdemi=%g",Tdemi);
    DebugUART.baud(9600);   //vitesse de comunication
    BTH.baud(9600);         // vitesse de comunication
    char CAR,CH;               // caracter envoyé
    mot1.period_us(100);    //periode des moteurs
    mot2.period_us(100);
    while(1) {
        if (BTH.readable()) {
            CH=CAR;
            CAR=BTH.getc();
            //printf("\n\r caractere lu = %c %c",CAR,CH);//affiche le caractere
        }

        if(CAR=='A') {   //A tour sur lui meme POSSIBLE AVEC LES CRANS 34
            if(CH!=CAR) {
                T1.start();
                //printf("start");
                sens_vitesse(vmot1TOUR,1);  //moteur droit rapport cyclique 50 sens avancer
                sens_vitesse(vmot2TOUR,2);  //moteur gauche rapport cyclique 50 sens reculer
            }

            if (T1.read()>=Ttour) {
                printf("t1");
                T1.stop();
                T1.reset();
                sens_vitesse(vmot_stop,1);
                sens_vitesse(vmot_stop,2);
            }
        }
        if(CAR=='B') {     //B robot avance
            sens_vitesse(vmot_avance,1);
            sens_vitesse(vmot_avance,2);
        }


        if(CAR=='C') {   //C demi tour sur lui meme POSSIBLE AVEC LES CRANS 17
            if(CH!=CAR) {
                T2.start();
                sens_vitesse(vmot1TOUR,1);  //moteur droit rapport cyclique 50 sens avancer
                sens_vitesse(vmot2TOUR,2);  //moteur gauche rapport cyclique 50 sens reculer
            }

            if (T2.read()>=Tdemi) {
                T2.stop();
                T2.reset();
                sens_vitesse(vmot_stop,1);
                sens_vitesse(vmot_stop,2);
            }
        }
        if(CAR=='F') { //F droit
            sens_vitesse(vmot_avance,1);  //moteur gauche rapport cyclique 50 sens avancer
            sens_vitesse(vmot_stop,2);  //moteur droit stop


        }
        if(CAR=='E') { //E stop
            sens_vitesse(vmot_stop,1);  //moteur droit stop
            sens_vitesse(vmot_stop,2);  //moteur gauche stop

        }

        if(CAR=='D') {    //D gauche
            sens_vitesse(vmot_avance,2);  //moteur droit rapport cyclique 50 sens avancer
            sens_vitesse(vmot_stop,1);  //moteur gauche stop

        }
        // G epreuve de la bute

        if(CAR=='H') {     //H robot recule
            sens_vitesse(vmot_recule,1);
            sens_vitesse(vmot_recule,2);
        }

    }

}


void sens_vitesse(int Periode,int mot)
{
    int sens;
    if (Periode<=0) {       // determination du sens 1 si peride inf a 0
        sens=1;
        Periode=abs(Periode); // valeurs abs de la periode donc en positif
    } else {
        sens=0;
    }
    if((mot==1)&&(sens==1)) {
        sens_gauche.write(1);
        mot1.pulsewidth_us(100-Periode); // 100-periode car sinon vitesse est de la difference entre 100 et la periode

    } else if((mot==1)&& (sens==0)) {
        sens_gauche.write(0);
        mot1.pulsewidth_us(Periode);
    }

    if((mot==2)&&(sens==1)) {
        sens_droit.write(1);
        mot2.pulsewidth_us(100-Periode); // 100-periode car sinon vitesse est de la difference entre 100 et la periode
    } else if((mot==2)&& (sens==0)) {
        sens_droit.write(0);
        mot2.pulsewidth_us(Periode);
    }
}