#include "mbed.h"
#include "MFRC522.h"

//KL25Z Pins for MFRC522 SPI interface
#define SPI_MOSI    p5
#define SPI_MISO    p6
#define SPI_SCLK    p7
#define SPI_CS      p16
// KL25Z Pin for MFRC522 reset
#define MF_RESET    p8
void fct(void);
Ticker T1;
DigitalOut LedRed (LED1);
DigitalOut LedGreen (LED2);
MFRC522 RfChip (SPI_MOSI, SPI_MISO, SPI_SCLK,SPI_CS,MF_RESET);
int main()
{
    RfChip.PCD_Init();
    T1.attach(&fct,0.2);
    while(1) {
        wait_ms(200);
    }
}
void fct(void){
    if (  RfChip.PICC_IsNewCardPresent()) {
        if(RfChip.PICC_ReadCardSerial()) {
            LedRed   = 1;
            LedGreen = 0;
            printf("Card UID: ");
            // Print Card UID
            for (uint8_t i = 0; i < RfChip.uid.size; i++) {
                printf(" %02X", RfChip.uid.uidByte[i]);
            }
            printf("\n\r");

            // Print Card type
            uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
            printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
            wait_ms(500);

        }
    }
}
    