#include "mbed.h"
#include "pinmap.h"

#ifndef NBANALOGIN_H
#define NBANALOGIN_H

#define ADC_BUF_SIZE 100
#define ADC_CHANNELS 8

/** Library for non blocking ADC operation
  */
  
class NbAnalogIn{
public:

    
    /**
    * Create a NbAnalogIn object, sets up ADC
    *
    * @param pin AnalogIn pin to connect to
    */
    NbAnalogIn( PinName pin );
    
    /**
    * Set interrupt options
    *
    * @param irqfunc - callback function executed at the end of interrupts
    * @param priority - set interrupt priority level. -1 (default) leaves them unchanged
    */
    void setInterrupt(void (*irqfunc)() = 0, int prio = -1);
    
    /**
    * does a single blocking read and returns a 12 bit output
    */
    int readBl();
    
    /**
    * starts a conversion and sets the interrupt to fire when ADC is finished
    * the result will be put into the internal buffer
    *
    * @param wait - If true, wait for current adc conversion to finish, 
    *               if false (default), stop the current conversion replace it
    */
    void triggerConv(bool wait = false);    
    
    /**
    * checks if the buffer has new results that can be read
    */
    bool readable();
    
    /**
    * returns the next value from the buffer
    */
    int read();
    
    /** An operator shorthand for read()
    */
    operator int() {
        return read();
    }
    
        
private:
    
    int buffer[ADC_BUF_SIZE];
    int write_pos;      // next position to be written to
    int read_pos;       // next position to be read from
    
    static volatile bool converting;
    
    uint8_t channel;    // channel of current object (ADC0-7)
    void handler( int adc_result );
    
    static void irq();
    static NbAnalogIn* handlers[ADC_CHANNELS]; 
    
    // custom interrupt handler which, if set, is called after the internal
    // interrupt handling
    void (* cirq)(); 
    
};


#endif