#include "mbed.h"
#include "MMA8451Q_tb.h"
#include "SDFileSystem.h"
#include "math.h"
 
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)
float acc_all[3];
DigitalOut pinout(PTD4);
Timer timer;
Serial pc(USBTX, USBRX);
SDFileSystem sd(PTD2, PTD3, PTD1, PTD0, "sd"); // (mosi, miso, sclok, cs, name)

int main(void) {
    
//Initialize
    int now;                //used for timestamping  
    int counter = 0;        //used for step counting
    int step_flag = 0;      //used to sense transition into step
    float threshold = 1.43; //tunable in g's [m/s^2]
    float mag = 0; 
    float x = 0;
    float y = 0;
    float z = 0;
    timer.start(); 
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    printf("MMA8451 ID: %d\n", acc.getWhoAmI());

//Open File
    //mkdir("/sd/mydir", 0777);
    //FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");
    //if(fp == NULL) {
    //    error("Could not open file for write\n");
    //}

    while(1){
    //for(int i=0; i<2000; i++) {
        pinout = !pinout;
        now = timer.read_ms();
        acc.fastRead(&acc_all[0]);
        x = acc_all[0];
        y = acc_all[1];
        z = acc_all[2];
        
        mag = sqrt(x*x + y*y + z*z);
       //Print to file
     //   fprintf(fp, "%d, %f,%f,%f\n",now, acc_all[0],acc_all[1],acc_all[2]);
        
    //}
    //fclose(fp);
   // pc.printf("mag: %f\n", mag);
        if (mag > threshold){
            if (step_flag == 0){
                counter++;
                pc.printf("step_count:%d mag: %f\n", counter, mag);
            }  
            step_flag = 1;
        }
        else {
            step_flag = 0;
            }  
        
    }
}
