#include "mbed.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define REG_WHO_AM_I        0x0D
#define REG_CTRL_REG1       0x2A
#define REG_CTRL_REG2       0x2B
#define REG_CTRL_REG3       0x2C
#define REG_SYSMOD          0x0B
#define REG_OUT_X_MSB       0x01
  

DigitalOut myled(LED_GREEN);
Serial pc(USBTX, USBRX);
I2C i2c(PTE25, PTE24); //MMA8451 Accelerometer


int main() {
    pc.baud(9600);
    
    uint8_t reg1_orig;
    char t1[1] = {REG_CTRL_REG1};
    i2c.write(MMA8451_I2C_ADDRESS, t1, 1, true);
    i2c.read(MMA8451_I2C_ADDRESS, (char*) &reg1_orig, 1);
    
    uint8_t reg2_orig;
    char t3[1] = {REG_CTRL_REG2};
    i2c.write(MMA8451_I2C_ADDRESS, t3, 1, true);
    i2c.read(MMA8451_I2C_ADDRESS, (char*) &reg2_orig, 1);
    
    while (true) {
        
        //This uses the I2C library function long forms
        
        pc.printf("reg1_orig: %x\n", reg1_orig);
        pc.printf("reg2_orig: %x\n", reg2_orig);

        
        uint8_t who_am_i;
        char t[1] = {REG_WHO_AM_I};
        i2c.write(MMA8451_I2C_ADDRESS, t, 1, true);
        i2c.read(MMA8451_I2C_ADDRESS, (char*) &who_am_i, 1);
        pc.printf("WAI: %x\n", who_am_i);  //Print both to screen
        
        uint8_t x_val;
        char tx_val[1] = {REG_OUT_X_MSB};
        i2c.write(MMA8451_I2C_ADDRESS, tx_val, 1, true);
        i2c.read(MMA8451_I2C_ADDRESS, (char*) &x_val, 1);
        pc.printf("x: %x\n", x_val);  //Print both to screen
        
        myled=0;
        wait(0.1);
        myled=1;
        wait(0.1);
        myled=0;
        wait(0.1);
        myled=1;
        wait(0.1);
        
        uint8_t w1[2] = {REG_CTRL_REG1, 0x01};
        i2c.write(MMA8451_I2C_ADDRESS, (char *) w1, 2);
        uint8_t w2[2] = {REG_CTRL_REG2, 0x00};
        i2c.write(MMA8451_I2C_ADDRESS, (char *) w2, 2);
        wait(5); //delay for measurement
        
        myled=0;
        wait(0.1);
        myled=1;
        wait(0.1);
        
        uint8_t w1_off[2] = {REG_CTRL_REG1, 0x00};
        i2c.write(MMA8451_I2C_ADDRESS, (char *) w1_off, 2);
        wait(5); //delay for measurement

        
        uint8_t reg1_value=6;
        i2c.write(MMA8451_I2C_ADDRESS, t1, 1, true);
        i2c.read(MMA8451_I2C_ADDRESS, (char*) &reg1_value, 1);
        pc.printf("reg1_new: %x\n", reg1_value);  //Print both to screen

        uint8_t reg2_value=6;
        i2c.write(MMA8451_I2C_ADDRESS, t3, 1, true);
        i2c.read(MMA8451_I2C_ADDRESS, (char*) &reg2_value, 1);
        pc.printf("reg2_new: %x\n", reg2_value);  //Print both to screen


        //End of Long form
        //wait(5);
        
        uint8_t sys_mod;
        char t2[1] = {REG_SYSMOD};
        i2c.write(MMA8451_I2C_ADDRESS, t2, 1, true);
        i2c.read(MMA8451_I2C_ADDRESS, (char*) &sys_mod, 1);
        pc.printf("Sysmod: %x\n", sys_mod);  //Print both to screen

        //pc.printf("WAI: %x, Reg1: %x\n", who_am_i, reg1_value);  //Print both to screen
        //pc.printf("Short: %x Long: %x\n", who_am_i, who_am_i_2);  //Print both to screen

        //myled = !myled; //Heartbeat
    }
}

/*    
void MMA8451Q::readRegs(int addr, uint8_t * data, int len) {
    char t[1] = {addr};
    m_i2c.write(m_addr, t, 1, true);
    m_i2c.read(m_addr, (char *)data, len);
}*/