#ifndef Start_H
#define Start_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Me.h"
#include "Attacker.h"

                        //head file referenced from pongengine.h in Pong example
/** Start Class  
* @brief Start
* @author dongyuhu  
* @date April, 2020 
*/ 
class Start
{

public:
    /** Constructor */
    Start();
    /** Destructor */ 
    ~Start();

    /** Initialization 
    *@param the values of height,width and speed(int) 
    */ 
    void init(int me_width,int me_height,int attacker_size,int speed);
    
    /** read input of Gamepad */
    void read_input(Gamepad &pad);
    
    /** Update the values */ 
    void update(Gamepad &pad);
    
    /** draw pattern on lcd*/
    void draw(N5110 &lcd);
    /** get the value of human life
    *@return the current value of human life
    */ 

    void check_wall_collision(Gamepad &pad);
    /** get the value of score
    *@return the current value of score
    */ 
    void check_body_collisions(Gamepad &pad);
private:

    Attacker _attacker1;
    Attacker _attacker2;
    Attacker _attacker3;
    Attacker _attacker4;
    Attacker _attacker5;
    Attacker _attacker6;
    Attacker _attacker7;
    Attacker _attacker8;

    Me _me;
    int _mex;
    int _mey;

    int _me_width;      //3
    int _me_height;     //3
    int _attacker_size; //2
    int _speed;         //1




    Direction _d;
    float _mag;

};

#endif