/* ELEC2645 Embedded Systems Project 
School of Electronic & Electrical Engineering 
University of Leeds 
Name: Hu Dongyu
Username: dongyuhu
Student ID Number: 201199421
Date: 04/05/2020
 */ 
 
#include <stdlib.h>
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Start.h"

/*Initialized data*/
#define G_Width 84
#define G_Height 48 
#define M_Width  3 
#define M_Height 3 
#define A_Size 2       
#define A_Speed 1

#define wait_time1 1

extern bool ifnotstop;


/*Create the external class object*/
N5110 Monitor(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);// from external class N5110
Gamepad GP;// from external class Gamepad
Start sta;// from external class start



void Gameinit()//Game Initialization
{
    Monitor.init();
    GP.init();
    sta.init(M_Width,M_Height,A_Size,A_Speed);
}


void draw_frame_for_Monitor()// draw frame for the Monitor
{
    Monitor.clear();//Monitor clear 
    sta.draw(Monitor);//redraw
    Monitor.refresh();//refresh
}


void Showmenu()//show game menu
{
    
    Monitor.printString("    ARENA   ",0,1);  
    Monitor.printString("  Press Start ",0,4);
    Monitor.refresh();//refresh Monitor
    while ( GP.check_event(Gamepad::START_PRESSED) == false) 
    { 
        ;
    }
}

void dofunction(int FPS)
{
    sta.read_input(GP);
    sta.update(GP);
    draw_frame_for_Monitor();
    wait(1.0f/FPS);
}

int main()
{
    while(1)
    {
        int FPS = 10;//fps=10
        Gameinit();//initialization     
        Showmenu();  //show menu
        draw_frame_for_Monitor();
        wait(wait_time1);  
        while(ifnotstop) 
        {
            dofunction(FPS);
        }
        if(ifnotstop == false)
        {
            Monitor.clear();
            Monitor.printString("  Game over ",0,4);
            Monitor.refresh();
        }
        wait(5);
        ifnotstop = true;
    }
}

