// I2Cdev and MPU9150 must be installed as libraries, or else the .cpp/.h files
// for both classes must be in the include path of your project
#include "I2Cdev.h"  //MPU9150's I2C (I2C_SDA D14,I2C_SCL D15)
#include "MPU9150.h"
#include "helper_3dmath.h"
#include "mbed.h"
#include "JPEGCamera.h"
#include "MPU9150_raw.h"
#include <cstring>
#include "string.h"
#define buf_max 200

Serial control(SERIAL_TX, SERIAL_RX);
JPEGCamera camera(PA_9, PA_10);//D8,D2
//Serial gps(PA_11, PA_12);
Serial sim808(PA_11, PA_12);                // arduino pin right seven(PA_11) , six(PA_12)

Timer timer;
int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;
int16_t buf9150[10];
char buffer1[256];
//volatile int sig=0;
//volatile int i=0;
int First_Int = 0;                         //receive count
char sim_buf[buf_max];                     //receive buffer data
char *content="HELLO,This is a test";      //message content
char CtrlZ = 0x1a;                         //send direction

void SIM808_IRQHandler(void);              //interrupt
void CLR_Buf(void);                        //clear buffer                                         
bool Judge_SIM808();                       //judge AT
void Wait_CREG(void);

//void getline();
//void callback(){         
//    getline();
//    }
int main()
{
    int message = 0;
    
    control.baud(115200);
    
    //Camera Initialization and picture sizing
    timer.start();
    camera.setPictureSize(JPEGCamera::SIZE160x120);
    wait(3);
    //Continuously wait for commands
    while(1) 
    {
//        if(control.readable()) 
//        {
            control.readable();
            message=control.getc();    
            //Take a picture (note that this takes a while to complete and will only only work for 999 pictures
            if (message==210){                         //send D2 for taking a picture
                camera.isReady();
                camera.takePicture();
                int image_size = camera.getImageSize();
                    while (camera.isProcessing()) 
                        {
                            camera.processPicture(control);
                        }
                    }
            else if (message==212){                    //send D4 for getting datas of MPU9150
                MPU9150raw::setup();    
                MPU9150raw::loop();
                control.printf("ax=%d\n",buf9150[0]);
                control.printf("ay=%d\n",buf9150[1]);
                control.printf("az=%d\n",buf9150[2]);
                control.printf("gx=%d\n",buf9150[3]);
                control.printf("gy=%d\n",buf9150[4]);
                control.printf("gz=%d\n",buf9150[5]);
                control.printf("mx=%d\n",buf9150[6]);
                control.printf("my=%d\n",buf9150[7]);
                control.printf("mz=%d\n",buf9150[8]);
            }
            else if (message==214){                   //send D6 for GPRS
                sim808.attach(&SIM808_IRQHandler,SerialBase::RxIrq);    //serial interrupt attach
                wait(5);
    
                sim808.printf("AT\r\n");
                wait(3);                                       //判断Serial sim808通信是否正常
                if(Judge_SIM808()){
                control.printf("sim808 uart success\n");
                  }
                else{
                control.printf("sim808 uart fail\n");
                  }
                CLR_Buf();
    
                sim808.printf("ATE0\r\n");                     //关闭回显 
                wait(3);
                if(Judge_SIM808()){
                control.printf("sim808 ATEO turn off success\n");
                  }
                else{
                control.printf("sim808 ATEO turn off fail\n");
                  }                                                 
                CLR_Buf(); 

                sim808.printf("AT+CREG?\r\n");                 //判断SIM卡是否注册成功
                wait(3);
                if(Judge_SIM808()){
                control.printf("sim808 register success\n");
                 }
                else{
                control.printf("sim808 register fail\n");
                 }                                                  
                CLR_Buf();        
    
/************************************************
      sim808.printf("AT+CMGF=1\r\n");                //Text mode短信发送模式
      wait(3);
      if(Judge_SIM808()){
        control.printf("sim808 TEXT set success\n");
          }
      else{
        control.printf("sim808 TEXT set fail\n");
          }                                                
      
      CLR_Buf(); 

      sim808.printf("AT+CSCS=\"GSM\"\r\n");           //设置GSM模式
      wait(3);
      ret=Judge_SIM808();
      if(ret){
        control.printf("sim808 GSM set success\n");
          }
      else{
        control.printf("sim808 GSM set fail\n");
          }                                                
      
      CLR_Buf();

      sim808.printf("AT+CSMP=17,167,0,0\r\n");      //Text parameter set
      wait(3);
      ret=Judge_SIM808();
      if(ret){
        control.printf("sim808 Text parameter set success\n");
          }
      else{
        control.printf("sim808 Text parameter set fail\n");
          }
      
      CLR_Buf();

      sim808.printf("AT+CMGS=\"+8618766569612\"\r\n");      //receiver's phone number
       wait(3);
      ret=Judge_SIM808();
      if(ret==true){
        control.printf("%s",sim_buf);
          }
      else{
        control.printf("sim808 receive number fail\n");
          }
     
      CLR_Buf();
    
      sim808.printf("%s",(char*)content);           //短信内容
      sim808.printf("%c",CtrlZ);   
      wait(3);                
      control.printf("%s\n",sim_buf);
      CLR_Buf();

******************************************/    
      sim808.printf("AT+CPIN?\r\n");
      wait(3);
      if(Judge_SIM808()){
        control.printf("sim808 SIM card success\n");          //SIM状态
          }
      else{
        control.printf("sim808 SIM card set fail\n");
          }
      
      CLR_Buf();
      
      sim808.printf("AT+CGATT?\r\n");                  //GPRS附着状态
      wait(3);
      if(Judge_SIM808()){
        control.printf("sim808 GPRS success\n");
          }
      else{
        control.printf("sim808 GPRS set fail\n");
          }
      
      CLR_Buf();
      
      sim808.printf("AT+CSTT=\"CMNET\"\r\n");         //set APN
      wait(3);
      if(Judge_SIM808()){
        control.printf("sim808 APN set success\n");
          }
      else{
        control.printf("sim808 APN set fail\n");
          }
      CLR_Buf();
      
      sim808.printf("AT+CIICR\r\n");                    //wireless link
      wait(3);
      if(Judge_SIM808()){
        control.printf("sim808 wireless link success\n");
          }
      else{
        control.printf("sim808 wireless link fail\n");
          }
      CLR_Buf();
      
      sim808.printf("AT+CIPSTART=\"TCP\",\"122.5.17.146\",\"9970\"\r\n");       //TCP set
      wait(3);
      if(Judge_SIM808()){
        control.printf("sim808 TCP set success\n");
          }
      else{
        control.printf("sim808 TCP set fail\n");
          }
      CLR_Buf();
      
      sim808.printf("AT+CIPSEND\r\n");               //send direction
      wait(3);
      CLR_Buf();
      
      sim808.printf("%s\n",(char*)content);           //发送内容
      sim808.printf("%c",CtrlZ);
      }
   }
}
/*******************************************
        control.printf("start test!\r\n");         //GPS without change
        gps.attach(&callback);
            hal_sleep();
            if(sig == 7)
            {
                sig=0;
                i=0;
            control.printf("%s",buffer1);
          memset(buffer1,0,sizeof(buffer1));              
            }
           wait(5);                            
        }
}
void getline() 
    {
     buffer1[i] = gps.getc();
     if(buffer1[i] == 0x0a)
              {
               sig++;    
      }
            i++;
    }
*********************************/
void SIM808_IRQHandler(void)                    
{    
    if(First_Int>=buf_max)First_Int=0;
    sim_buf[First_Int] = sim808.getc();
    First_Int++; 
}
void CLR_Buf(void)
{
    uint16_t k;
    for(k=0;k<buf_max;k++)      
    {
        sim_buf[k] = 0x00;
    }
    First_Int = 0;              
}
bool Judge_SIM808()
{
    int j;
    for(j=0;j<buf_max;j++)                  
    {
            if((sim_buf[j] == 'O')&&(sim_buf[j+1] == 'K'))
                {
                    CLR_Buf();
                    return true;    
                }
    }
    CLR_Buf();
    return false;
}
namespace MPU9150raw {
// class default I2C address is 0x68
// specific I2C addresses may be passed as a parameter here
// AD0 low = 0x68 (default for InvenSense evaluation board)
// AD0 high = 0x69
    MPU9150 accelGyroMag;
    void setup() {
      //control.baud(115200);
      accelGyroMag.initialize();
      }

    void loop() {
    // read raw accel/gyro/mag measurements from device
      accelGyroMag.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz);
      buf9150[0]=ax;buf9150[1]=ay;buf9150[2]=az;
      buf9150[3]=gx;buf9150[4]=gy;buf9150[5]=gz;
      buf9150[6]=mx;buf9150[7]=my;buf9150[8]=mz;
      wait_ms(50);
      }
}