//#include "mbedOS.h"
#include "mbed.h"

#include "myf401.h"

#include "vector"
int f401Act::f401cnt=0;
int f401Act::datacnt=0;
/******iwdg instance*********/
//IWDG_HandleTypeDef f401Act::hiwdg; //?????
/******pc uart instance*********/
Serial f401Act::uart(DEBUG_TX, DEBUG_RX);                        //PA_9, PA_10 to pc debug
/******led instance*********/                                   
DigitalOut f401Act::led2(LED2);                                         //PC_8
DigitalOut f401Act::led3(LED3);                                         //PC_9
/**** time1 intance*****/
Ticker f401Act::time1;
Ticker f401Act::timerone;
Timer f401Act::outtime;

extern string send_udp3;

char f401Act::buf[512]={0x00};   
char bufz[512]="";
/*******************************
Desc.: f401pc initializations,include iwdg\system tick\key interrupt
Auth.:ZY
Vesion:2017.7.2
*******************************/
void f401Act::init(void)   
{
    /*******iwdg init*******/
    //hiwdg.Instance=IWDG;//??
    //hiwdg.Init.Prescaler=IWDG_PRESCALER_16;//???       分频因子[4,8,16,32,64,128,256,256]
    //hiwdg.Init.Reload=4095;//???                       递减计数0~0XFFF
    //HAL_IWDG_Init(&hiwdg);  //???
    //set_time(1514806505);//自1970年1月1日0时0分0秒到2018年1月1日11时35分05秒
    f401Act::time1.attach(&isr_tick,1.0);                                    //定时器中断设置
    f401Act::timerone.attach_us(&isr_tick1,1000);         //定时器中断配置
}

/*****************************************
Desc.: pc ready
Auth.:ZY
Vesion:2017.7.2
*****************************************/
void f401Act::ready(void)
{
    uart.baud(9600);    
    uart.attach(&isr_pc,SerialBase::RxIrq);
}

/*****************************************
Desc.: pc get
Auth.:ZY
Vesion:2017.7.2
*****************************************/
void f401Act::get(void)
{  
    uart.putc(0x31);                //接受母钟数据请求(协议)
    wait_ms(500);
    //for(int i=0;i<datacnt;i++) bufCom[i]=buf[i];
    //for(int i=0;i<datacnt;i++){
        //uart.putc(buf[i]);
        //buf[i]=0;
    //}
    F401script::poC_getS=1;
}

/*****************************************
Desc.: 呼叫母钟,五次
Auth.:ZY
Vesion:2017.7.2
*****************************************/
void f401Act::put_call(void)
{
    outtime.start();
    outtime.reset();
    while(F401script::poC_isrS==0||outtime.read_ms()<=50){
        uart.putc(0x53);
        wait_ms(1);
    }
    outtime.stop();
    if(F401script::poC_isrS==1){
        F401script::poC_isrS=0;
        
        F401script::poC_putcallS=1;
    }
}
        
/*****************************************
Desc.:reflesh iwdg
Auth.:ZY
Vesion:2017.7.2
*****************************************/
//void f401Act::reiwdg(void)
//{
    //HAL_IWDG_Refresh(&hiwdg);  //????                                             //reflesh iwdg
//}
void f401Act::isr_tick(void)
{
    F401script::poC_ticisrS=1;
 
}
/*****************************************
Desc.: system ticker ISR
Auth.:ZY
Vesion:2017.7.2
*****************************************/
void f401Act::isr_tick1(void)
{
    if(F401script::poC_step>0) F401script::poC_step--;              
    
    if(F401script::poC_step==1){
        datacnt=f401cnt;                //获取数据个数
        send_udp3.clear();
        //for(int i=0;i<f401cnt;i++) send_udp3.push_back(buf[i]);
        send_udp3=bufz;
        f401cnt=0;       //数据缓存个数清零
        memset(bufz,0,sizeof(buf));
        memset(buf,0,sizeof(buf));
    }
}
/*****************************************
Desc.: pc getc ISR
Auth.:ZY
Vesion:2017.7.2
*****************************************/
void f401Act::isr_pc(void)
{  
    F401script::poC_step=20;                           //计时3ms
    char bufx;
    char bufy[40]="";
    bufx=uart.getc();
    buf[f401cnt]=bufx;
    sprintf(bufy,"%02X",bufx);
    strcat(bufz,bufy);
    //if(buf[0]==0x41) F401script::poC_isrS=1;       //打印测试发送"AT+QWERTY=1"  buf[10]=1
    f401cnt++;
    if(f401cnt>512) f401cnt=0;          //防止溢出
}



