#include "mbed.h"
#include <string>

#define buf_max         256

Serial pc(SERIAL_TX, SERIAL_RX);
Serial sim808(PA_9, PA_10);
DigitalOut sim_power(D4);//PB_5  //复位SIM808

int  rec_cnt = 0;                         //receive count
char result[buf_max];

void sim_callback()
{
    char x;
    x = sim808.getc();
    result[rec_cnt++]= x;
    pc.putc(x);
        if(rec_cnt>=buf_max-1)rec_cnt=0;
}
bool sim_wait(int x)
{
    char *p; 
    rec_cnt = 0;
    memset(result,0,buf_max*sizeof(char));
    while(x)
    {
        wait(1);
        p=strstr(result,"OK");
        if(p) 
        {    
            return true;
        } 
         x--;
    }
    return false;
}

int main()
{
    pc.baud(115200);
    sim808.baud(115200);
    sim808.attach(&sim_callback,SerialBase::RxIrq);
    
    pc.printf("AT+CGNSPWR=1\r\n");                 //打开GPS
    sim808.printf("AT+CGNSPWR=1\r\n");
    
    if(sim_wait(1)){
        pc.printf("GPS Open Success\r\n");
    } 
    else{
        pc.printf("GPS Open Failed\r\n");
    }
    pc.printf("AT+CGNSURC=1\r\n");               //每秒发送一次GPS定位信息
    sim808.printf("AT+CGNSURC=1\r\n");
    wait(10);
    pc.printf("AT+CGNSPWR=0\r\n");               //关闭GPS
    sim808.printf("AT+CGNSPWR=0\r\n");
}