
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "NokiaLCD.h"

NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type

EthernetNetIf eth; 
HTTPClient http;
LocalFileSystem local("local"); 
HTTPResult result;
bool completed = false;

void request_callback(HTTPResult r)
{
  result = r;
  completed = true;
}

int main() {

   lcd.background(0x0000FF);
    lcd.cls();

  printf("Start\n");

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  HTTPStream stream;
  
  int flag = 0;
  int count = 0;
  int pixel = 1;
  char c;
  char buffer[100];
  char BigBuf[512 + 1] = {0};
  stream.readNext((byte*)BigBuf, 512); //Point to buffer for the first read
  
  HTTPResult r = http.get("http://rss.cnn.com/rss/cnn_topstories.rss", &stream, request_callback); //Load a very large page, such as the hackaday RSS feed
  FILE *fp = fopen("/local/out.txt", "w");  // Open "out.txt" on the local file system for writing
  while(!completed)
  {
    Net::poll(); //Polls the Networking stack
    if(stream.readable())
    {
      BigBuf[stream.readLen()] = 0; //Transform this buffer in a zero-terminated char* string
      fprintf(fp,BigBuf);
      //Note: some servers do not like if you throttle them too much, so printf'ing during a request is generally bad practice
      stream.readNext((byte*)BigBuf, 512); //Buffer has been read, now we can put more data in it
    }
  }
  fclose(fp); 
  fp = fopen( "/local/out.txt", "r");
  if (fp==NULL) printf ("Error opening file");
  else
  {
    do
    {
      c = fgetc (fp);
      if (c == '<')
      {
        c = fgetc(fp);
        if(c == 't')
        {
          c = fgetc(fp);
          if(c == 'i')
          {
            c = fgetc(fp);
            if(c == 't')
            {
              c = fgetc(fp);
              if( c == 'l')
              {
                c = fgetc(fp);
                if( c == 'e')
                {
                  c = fgetc(fp);
                  if(c == '>')
                  {
                    count++;
                    if((count >=3) && (count <=5))
                    {
                    if(count == 6) break;
                    int i = 0;
                    c = fgetc(fp);
                    while(c != '<')
                    {
                        buffer[i] = c;
                        i++;
                        c = fgetc(fp);
                    }
                    buffer[i] = '\0';
                    lcd.locate(0,pixel);
                    lcd.printf("%s",buffer);
                    pixel += 5;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }while (count <= 5);
    fclose (fp);
  } 

  if(result == HTTP_OK)
  {
    printf("Read completely\n"); 
  }
  else
  {
    printf("Error %d\n", result);
  }

  return 0;
  
}


