/* cc.h */
/*
Copyright (C) 2012 ARM Limited.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#ifndef CC_H_
#define CC_H_

#include <stdint.h>

//This file was written according to http://lwip.wikia.com/wiki/Porting_for_an_OS and http://git.savannah.gnu.org/cgit/lwip.git/tree/doc/sys_arch.txt

//Data types
typedef uint8_t u8_t;
typedef uint16_t u16_t;
typedef uint32_t u32_t;

typedef int8_t s8_t;
typedef int16_t s16_t;
typedef int32_t s32_t;

typedef uint32_t mem_ptr_t;

//Debug
//__DEBUG__ must be defined to enable the macros
#ifndef __DEBUG__
#define __DEBUG__ 4 //Maximum verbosity
#endif
#ifndef __MODULE__
#define __MODULE__ "LwIP"
#endif
#include "dbg.h"

#define LWIP_PLATFORM_DIAG(...)  DBG(__VA_ARGS__)
//#define LWIP_PLATFORM_ASSERT(x) do{ ERR(x); } while(0)
#define LWIP_PLATFORM_ASSERT(...) ERR(__VA_ARGS__)

//Printf formatters
#define U16_F "hu"
#define S16_F "d"
#define X16_F "hx"
#define U32_F "u"
#define S32_F "d"
#define X32_F "x"
#define SZT_F "uz"

//Endianness
#define BYTE_ORDER LITTLE_ENDIAN

#define LWIP_PLATFORM_BYTESWAP 1
/*
#define LWIP_PLATFORM_HTONS(x) ( (((u16_t)(x))>>8) | (((x)&0xFF)<<8) )
#define LWIP_PLATFORM_HTONL(x) ( (((u32_t)(x))>>24) | (((x)&0xFF0000)>>8) \
                               | (((x)&0xFF00)<<8) | (((x)&0xFF)<<24) )
*/

#include "cmsis.h"
#define LWIP_PLATFORM_HTONS(x)      __REV16(x)
#define LWIP_PLATFORM_HTONL(x)      __REV(x)

//Checksums
/*
IP protocols use checksums (see RFC 1071). LwIP gives you a choice of 3 algorithms:
load byte by byte, construct 16 bits word and add: not efficient for most platforms
load first byte if odd address, loop processing 16 bits words, add last byte.
load first byte and word if not 4 byte aligned, loop processing 32 bits words, add last word/byte.
*/
#define LWIP_CHKSUM_ALGORITHM 3

//Structure packing 
#if defined ( __CC_ARM )

//This will work with ARMCC
#define PACK_STRUCT_FIELD(x) x//__packed x
#define PACK_STRUCT_STRUCT
#define PACK_STRUCT_BEGIN __packed
#define PACK_STRUCT_END
#define ALIGNED(n)  __align(n)

#elif   defined ( __GNUC__ )

//This will work with GCC and ARMCC in GCC-compatible mode
#define PACK_STRUCT_FIELD(x) x __attribute__((packed))
#define PACK_STRUCT_STRUCT __attribute__((packed))
#define PACK_STRUCT_BEGIN
#define PACK_STRUCT_END
#define ALIGNED(n)  __attribute__((aligned (n)))

#else
#error "This toolchain is not currently supported for LwIP support (you can FIXME)"
#endif

#define LWIP_PROVIDE_ERRNO

#define SYS_LIGHTWEIGHT_PROT 1
/*
sys.h will provide default definitions (as of version 1.3.0) of these macros as:
#define SYS_ARCH_DECL_PROTECT(lev) sys_prot_t lev
#define SYS_ARCH_PROTECT(lev) lev = sys_arch_protect()
#define SYS_ARCH_UNPROTECT(lev) sys_arch_unprotect(lev)
*/

#endif /* CC_H_ */
