#include "mbed.h"

DigitalOut led(LED1);

#include "ZG2100NetIf.h"
#include "NTPClient.h"
#include "HTTPClient.h"

Serial pc(USBTX, USBRX);

const byte wep_key[5] = {0x01, 0x02, 0x03, 0x04, 0x05};

ZG2100NetIf wifi(p5, p6, p7, p8, p9, p10); 
HTTPClient http;
NTPClient ntp;
  

int main() {

  pc.baud(115200);
  
  printf("Start\n");
  
  wifi.init();
  
  printf("Init\n");

  wifi.setSsid("mbed");
  //wifi.setWpaPass("thisismypassphrase");
  wifi.setWepKey(wep_key, 5);
  
  ZG2100Err result = wifi.connect( ZG_BSS_INFRA, ZG_SECURITY_WEP );
 
  printf("Connection result %d\n", result);
  
  if( result > 1 )
  {
    printf("Connection error\n");
    error("\n");
  }

  wifi.setup();
  
  printf("Setup.\n");

  time_t ctTime = time(NULL);  
  printf("Current time is : %s UTC\n", ctime(&ctTime));  

  Host server(IpAddr(), 123, "0.uk.pool.ntp.org");
  ntp.setTime(server);
    
  /*time_t*/ ctTime = time(NULL);  
  printf("Time is now : %s UTC\n", ctime(&ctTime)); 

  HTTPText txt;
  
  HTTPResult r = http.get("http://mbed.org/media/uploads/donatien/hello.txt", &txt);
  if(r==HTTP_OK)
  {
    printf("Result :\"%s\"\n", txt.gets()); 
  }
  else
  {
    printf("Error %d\n", r);
  }  
   
  while(1) {
    led = 1;
    wait(0.2);
    led = 0;
    wait(0.2);
  }
}
