#include "mbed.h"
#include "VodafoneUSBModem.h"
#include "Websocket.h"

void test(void const*) 
{
    VodafoneUSBModem modem;
    Websocket ws("ws://sockets.mbed.org:443/ws/demo/rw");
    char recv[128];
    
    int ret = modem.connect("pp.vodafone.co.uk");
    if(ret)
    {
      printf("Could not connect\n");
      return;
    }
    
    bool c = ws.connect();
    printf("Connect result: %s\n", c?"OK":"Failed");
    
    for(int i = 0; i < 10000; i++)
    {
        if(!(i%100))
        {
          int ret = ws.send("WebSocket Hello World over the Vodafone Network!");
          if(ret<0)
          {
            printf("Timeout\n");
            ws.close();
            c = ws.connect();
            printf("Connect result: %s\n", c?"OK":"Failed");
          }
        }
        
        if (ws.read(recv)) {
            printf("rcv: %s\r\n", recv);
        }

    }
    
    modem.disconnect();  

    while(1) {
    }
}


int main()
{
  Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
  DigitalOut led(LED1);
  while(1)
  {
    led=!led;
    Thread::wait(1000);  
  }

  return 0;
}
