#include "mbed.h"
#include "VodafoneUSBModem.h"
#include "NTPClient.h"

void test(void const*) 
{
    VodafoneUSBModem modem;
    NTPClient ntp;
    
    int ret = modem.connect("pp.vodafone.co.uk");
    if(ret)
    {
      printf("Could not connect\n");
      return;
    }
    
    printf("Trying to update time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0)
    {
      printf("Set time successfully\r\n");
      time_t ctTime;
      ctTime = time(NULL);
      printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    }
    else
    {
      printf("Error\r\n");
    } 
    
    modem.disconnect();  

    while(1) {
    }
}


int main()
{
  Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
  DigitalOut led(LED1);
  while(1)
  {
    led=!led;
    Thread::wait(1000);  
  }

  return 0;
}
