/* net_3g_websockets_test.cpp */
/*
Copyright (C) 2012 ARM Limited.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#define __DEBUG__ 4 //Maximum verbosity
#ifndef __MODULE__
#define __MODULE__ "net_3g_websockets_test.cpp"
#endif

#include "core/fwk.h"
#include "mbed.h"

#include "rtos.h"

#include "if/VodafoneK3770.h"
#include "Websocket.h"

#include "ADXL345.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
void notify(bool a, bool b, bool c)
{
  led1 = a;
  led2 = b;
  led3 = c;
}

extern "C" void HardFault_Handler()
{
  error("Hard Fault!\n");
}

void test(void const*)
{
  VodafoneK3770 threeg;
  Websocket ws("ws://sockets.mbed.org:443/ws/sensors/wo");
  const char* ws_channel = "3g_acc";

  ADXL345 accelerometer(p5, p6, p7, p8);

  int readings[3] = { 0, 0, 0 };
  char json_str[100];

  //Go into standby mode to configure the device.
  accelerometer.setPowerControl(0x00);
  accelerometer.setDataFormatControl(0x0B);
  accelerometer.setDataRate(ADXL345_3200HZ);
  accelerometer.setPowerControl(0x08);

  DBG("Hello!");

  do
  {
    notify(0, 1, 1);
    int ret = threeg.connect("pp.vodafone.co.uk");
    notify(0, 1, 0);
    if (ret == 0)
    {
      int ws_errors = 0;
      while (ws_errors < 100)
      {
        DBG("Connecting WS");
        if (ws.connect())
        {
          // DBG("streaming data on: \"%s\"", ws_channel);
          notify(0, 0, 1);

          while (ws.connected())
          {
            //we read accelerometers values
            accelerometer.getOutput(readings);
            sprintf(json_str,
                "{\"id\":\"%s\",\"ax\":\"%d\",\"ay\":\"%d\",\"az\":\"%d\"}",
                ws_channel, (int16_t) readings[0], (int16_t) readings[1],
                (int16_t) readings[2]);
            DBG("Sending: %s", json_str);
            ws.send(json_str);
            led3 = !led3;

            Thread::wait(300);
          }DBG("Disconnected");
          ws.close();
          ws_errors++;
        }
        else
        {
          WARN("Connection error, reset connection");
          break;
        }WARN("%d errors", ws_errors);
        Thread::wait(100); //Wait a bit before trying to reconnect
      }
      threeg.disconnect();
    }
    DBG("The mbed will reset in 1s");
    Thread::wait(1000);
    DBG("Reset");
    mbed_interface_reset(); //this is a major kludge because LwIP does NOT cleanup its threads when PPP is disconnected, so we need to start over

  } while (1);
  while (1)
  {
    Thread::wait(100);
  }
}

void keepAlive(void const*)
{
  while (1)
  {
    led1 = !led1;
    Thread::wait(500);
  }
}

void tick()
{
  led4 = !led4;
}

int main()
{
  Ticker t;
  t.attach(tick, 1);
  DBG_INIT();
  notify(1, 0, 0);

  Thread testTask(test, NULL, osPriorityNormal, 1500 * 4);
  keepAlive(NULL);

  return 0;
}
