/* net_sms_test.cpp */
/*
Copyright (C) 2012 ARM Limited.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#define __DEBUG__ 4 //Maximum verbosity
#ifndef __MODULE__
#define __MODULE__ "net_voda_k3770_test.cpp"
#endif

#define MY_PHONE_NUMBER "+44xxxxxxx"

#include "core/fwk.h"
#include "mbed.h"

#include "rtos.h"

#include "if/VodafoneK3770.h"

extern "C" void HardFault_Handler() {
    error("Hard Fault!\n");
}

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

void test(void const*) {
  VodafoneK3770 threeg;

  DBG("Hello!");
    
  threeg.sendSM(MY_PHONE_NUMBER, "Hello from mbed:)");

  while(true)
  {
    char num[17];
    char msg[64];
    size_t count;
    int ret = threeg.getSMCount(&count);
    if(ret)
    {
      WARN("getSMCount returned %d", ret);
      Thread::wait(3000);
      continue;
    }
    if( count > 0)
    {
      DBG("%d SMS to read", count);
      ret = threeg.getSM(num, msg, 64);
      if(ret)
      {
        WARN("getSM returned %d", ret);
        Thread::wait(3000);
        continue;
      }

      DBG("%s : %s", num, msg);
    }
    Thread::wait(3000);
  }

}

void keepAlive(void const*) {
   while(1)
   {
     led1=!led1;
     Thread::wait(500);
   }
}

void tick()
{
  led4=!led4;
}

int main() {
  Ticker t;
  t.attach(tick,1);
  DBG_INIT();

  Thread testTask(test, NULL, osPriorityNormal, 1024*4);
  keepAlive(NULL);

    
    return 0;
}
