/* net_3g_ntp_test.cpp */
/*
Copyright (C) 2012 ARM Limited.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#define __DEBUG__ 4 //Maximum verbosity
#ifndef __MODULE__
#define __MODULE__ "net_3g_ntp_test.cpp"
#endif

#include "core/fwk.h"
#include "mbed.h"

#include "rtos.h"

#include "if/VodafoneK3770.h"
#include "NTPClient.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
void notify(bool a, bool b, bool c)
{
  led1 = a;
  led2 = b;
  led3 = c;
}

extern "C" void HardFault_Handler()
{
  error("Hard Fault!\n");
}

void test(void const*)
{
  VodafoneK3770 threeg;
  NTPClient ntp;

  DBG("Hello!");

  notify(0, 1, 1);
  int ret = threeg.connect();
  notify(0, 1, 0);
  if (ret == OK)
  {
    DBG("Trying to update time...");
    if (ntp.setTime("0.pool.ntp.org") == OK)
    {
      DBG("Set time successfully");
    }
    else
    {
      WARN("Error");
    }
  }
  threeg.disconnect();
  DBG("Disconnected");

  notify(1, 1, 1);

  while (1)
  {
    Thread::wait(100);
  }
}

void keepAlive(void const*)
{
  while (1)
  {
    led1 = !led1;
    Thread::wait(500);
  }
}

void tick()
{
  led4 = !led4;
}

int main()
{
  Ticker t;
  t.attach(tick, 1);
  DBG_INIT();
  notify(1, 0, 0);

  Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
  keepAlive(NULL);

  return 0;
}
